/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.IpRangesCopier;
import software.amazon.awssdk.services.ec2.model.PrefixListIdSetCopier;
import software.amazon.awssdk.services.ec2.model.UserIdGroupPair;
import software.amazon.awssdk.services.ec2.model.UserIdGroupPairSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StaleIpPermission
implements ToCopyableBuilder<Builder, StaleIpPermission> {
    private final Integer fromPort;
    private final String ipProtocol;
    private final List<String> ipRanges;
    private final List<String> prefixListIds;
    private final Integer toPort;
    private final List<UserIdGroupPair> userIdGroupPairs;

    private StaleIpPermission(BuilderImpl builder) {
        this.fromPort = builder.fromPort;
        this.ipProtocol = builder.ipProtocol;
        this.ipRanges = builder.ipRanges;
        this.prefixListIds = builder.prefixListIds;
        this.toPort = builder.toPort;
        this.userIdGroupPairs = builder.userIdGroupPairs;
    }

    public Integer fromPort() {
        return this.fromPort;
    }

    public String ipProtocol() {
        return this.ipProtocol;
    }

    public List<String> ipRanges() {
        return this.ipRanges;
    }

    public List<String> prefixListIds() {
        return this.prefixListIds;
    }

    public Integer toPort() {
        return this.toPort;
    }

    public List<UserIdGroupPair> userIdGroupPairs() {
        return this.userIdGroupPairs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fromPort() == null ? 0 : this.fromPort().hashCode());
        hashCode = 31 * hashCode + (this.ipProtocol() == null ? 0 : this.ipProtocol().hashCode());
        hashCode = 31 * hashCode + (this.ipRanges() == null ? 0 : this.ipRanges().hashCode());
        hashCode = 31 * hashCode + (this.prefixListIds() == null ? 0 : this.prefixListIds().hashCode());
        hashCode = 31 * hashCode + (this.toPort() == null ? 0 : this.toPort().hashCode());
        hashCode = 31 * hashCode + (this.userIdGroupPairs() == null ? 0 : this.userIdGroupPairs().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaleIpPermission)) {
            return false;
        }
        StaleIpPermission other = (StaleIpPermission)obj;
        if (other.fromPort() == null ^ this.fromPort() == null) {
            return false;
        }
        if (other.fromPort() != null && !other.fromPort().equals(this.fromPort())) {
            return false;
        }
        if (other.ipProtocol() == null ^ this.ipProtocol() == null) {
            return false;
        }
        if (other.ipProtocol() != null && !other.ipProtocol().equals(this.ipProtocol())) {
            return false;
        }
        if (other.ipRanges() == null ^ this.ipRanges() == null) {
            return false;
        }
        if (other.ipRanges() != null && !other.ipRanges().equals(this.ipRanges())) {
            return false;
        }
        if (other.prefixListIds() == null ^ this.prefixListIds() == null) {
            return false;
        }
        if (other.prefixListIds() != null && !other.prefixListIds().equals(this.prefixListIds())) {
            return false;
        }
        if (other.toPort() == null ^ this.toPort() == null) {
            return false;
        }
        if (other.toPort() != null && !other.toPort().equals(this.toPort())) {
            return false;
        }
        if (other.userIdGroupPairs() == null ^ this.userIdGroupPairs() == null) {
            return false;
        }
        return other.userIdGroupPairs() == null || other.userIdGroupPairs().equals(this.userIdGroupPairs());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fromPort() != null) {
            sb.append("FromPort: ").append(this.fromPort()).append(",");
        }
        if (this.ipProtocol() != null) {
            sb.append("IpProtocol: ").append(this.ipProtocol()).append(",");
        }
        if (this.ipRanges() != null) {
            sb.append("IpRanges: ").append(this.ipRanges()).append(",");
        }
        if (this.prefixListIds() != null) {
            sb.append("PrefixListIds: ").append(this.prefixListIds()).append(",");
        }
        if (this.toPort() != null) {
            sb.append("ToPort: ").append(this.toPort()).append(",");
        }
        if (this.userIdGroupPairs() != null) {
            sb.append("UserIdGroupPairs: ").append(this.userIdGroupPairs()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer fromPort;
        private String ipProtocol;
        private List<String> ipRanges;
        private List<String> prefixListIds;
        private Integer toPort;
        private List<UserIdGroupPair> userIdGroupPairs;

        private BuilderImpl() {
        }

        private BuilderImpl(StaleIpPermission model) {
            this.setFromPort(model.fromPort);
            this.setIpProtocol(model.ipProtocol);
            this.setIpRanges(model.ipRanges);
            this.setPrefixListIds(model.prefixListIds);
            this.setToPort(model.toPort);
            this.setUserIdGroupPairs(model.userIdGroupPairs);
        }

        public final Integer getFromPort() {
            return this.fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final String getIpProtocol() {
            return this.ipProtocol;
        }

        @Override
        public final Builder ipProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public final void setIpProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
        }

        public final Collection<String> getIpRanges() {
            return this.ipRanges;
        }

        @Override
        public final Builder ipRanges(Collection<String> ipRanges) {
            this.ipRanges = IpRangesCopier.copy(ipRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRanges(String ... ipRanges) {
            this.ipRanges(Arrays.asList(ipRanges));
            return this;
        }

        public final void setIpRanges(Collection<String> ipRanges) {
            this.ipRanges = IpRangesCopier.copy(ipRanges);
        }

        public final Collection<String> getPrefixListIds() {
            return this.prefixListIds;
        }

        @Override
        public final Builder prefixListIds(Collection<String> prefixListIds) {
            this.prefixListIds = PrefixListIdSetCopier.copy(prefixListIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixListIds(String ... prefixListIds) {
            this.prefixListIds(Arrays.asList(prefixListIds));
            return this;
        }

        public final void setPrefixListIds(Collection<String> prefixListIds) {
            this.prefixListIds = PrefixListIdSetCopier.copy(prefixListIds);
        }

        public final Integer getToPort() {
            return this.toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final Collection<UserIdGroupPair> getUserIdGroupPairs() {
            return this.userIdGroupPairs;
        }

        @Override
        public final Builder userIdGroupPairs(Collection<UserIdGroupPair> userIdGroupPairs) {
            this.userIdGroupPairs = UserIdGroupPairSetCopier.copy(userIdGroupPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdGroupPairs(UserIdGroupPair ... userIdGroupPairs) {
            this.userIdGroupPairs(Arrays.asList(userIdGroupPairs));
            return this;
        }

        public final void setUserIdGroupPairs(Collection<UserIdGroupPair> userIdGroupPairs) {
            this.userIdGroupPairs = UserIdGroupPairSetCopier.copy(userIdGroupPairs);
        }

        public StaleIpPermission build() {
            return new StaleIpPermission(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StaleIpPermission> {
        public Builder fromPort(Integer var1);

        public Builder ipProtocol(String var1);

        public Builder ipRanges(Collection<String> var1);

        public Builder ipRanges(String ... var1);

        public Builder prefixListIds(Collection<String> var1);

        public Builder prefixListIds(String ... var1);

        public Builder toPort(Integer var1);

        public Builder userIdGroupPairs(Collection<UserIdGroupPair> var1);

        public Builder userIdGroupPairs(UserIdGroupPair ... var1);
    }
}

