/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.LaunchSpecification;
import software.amazon.awssdk.services.ec2.model.RIProductDescription;
import software.amazon.awssdk.services.ec2.model.SpotInstanceState;
import software.amazon.awssdk.services.ec2.model.SpotInstanceStateFault;
import software.amazon.awssdk.services.ec2.model.SpotInstanceStatus;
import software.amazon.awssdk.services.ec2.model.SpotInstanceType;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SpotInstanceRequest
implements ToCopyableBuilder<Builder, SpotInstanceRequest> {
    private final String actualBlockHourlyPrice;
    private final String availabilityZoneGroup;
    private final Integer blockDurationMinutes;
    private final Instant createTime;
    private final SpotInstanceStateFault fault;
    private final String instanceId;
    private final String launchGroup;
    private final LaunchSpecification launchSpecification;
    private final String launchedAvailabilityZone;
    private final String productDescription;
    private final String spotInstanceRequestId;
    private final String spotPrice;
    private final String state;
    private final SpotInstanceStatus status;
    private final List<Tag> tags;
    private final String type;
    private final Instant validFrom;
    private final Instant validUntil;

    private SpotInstanceRequest(BuilderImpl builder) {
        this.actualBlockHourlyPrice = builder.actualBlockHourlyPrice;
        this.availabilityZoneGroup = builder.availabilityZoneGroup;
        this.blockDurationMinutes = builder.blockDurationMinutes;
        this.createTime = builder.createTime;
        this.fault = builder.fault;
        this.instanceId = builder.instanceId;
        this.launchGroup = builder.launchGroup;
        this.launchSpecification = builder.launchSpecification;
        this.launchedAvailabilityZone = builder.launchedAvailabilityZone;
        this.productDescription = builder.productDescription;
        this.spotInstanceRequestId = builder.spotInstanceRequestId;
        this.spotPrice = builder.spotPrice;
        this.state = builder.state;
        this.status = builder.status;
        this.tags = builder.tags;
        this.type = builder.type;
        this.validFrom = builder.validFrom;
        this.validUntil = builder.validUntil;
    }

    public String actualBlockHourlyPrice() {
        return this.actualBlockHourlyPrice;
    }

    public String availabilityZoneGroup() {
        return this.availabilityZoneGroup;
    }

    public Integer blockDurationMinutes() {
        return this.blockDurationMinutes;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public SpotInstanceStateFault fault() {
        return this.fault;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String launchGroup() {
        return this.launchGroup;
    }

    public LaunchSpecification launchSpecification() {
        return this.launchSpecification;
    }

    public String launchedAvailabilityZone() {
        return this.launchedAvailabilityZone;
    }

    public String productDescription() {
        return this.productDescription;
    }

    public String spotInstanceRequestId() {
        return this.spotInstanceRequestId;
    }

    public String spotPrice() {
        return this.spotPrice;
    }

    public String state() {
        return this.state;
    }

    public SpotInstanceStatus status() {
        return this.status;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String type() {
        return this.type;
    }

    public Instant validFrom() {
        return this.validFrom;
    }

    public Instant validUntil() {
        return this.validUntil;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.actualBlockHourlyPrice() == null ? 0 : this.actualBlockHourlyPrice().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZoneGroup() == null ? 0 : this.availabilityZoneGroup().hashCode());
        hashCode = 31 * hashCode + (this.blockDurationMinutes() == null ? 0 : this.blockDurationMinutes().hashCode());
        hashCode = 31 * hashCode + (this.createTime() == null ? 0 : this.createTime().hashCode());
        hashCode = 31 * hashCode + (this.fault() == null ? 0 : this.fault().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.launchGroup() == null ? 0 : this.launchGroup().hashCode());
        hashCode = 31 * hashCode + (this.launchSpecification() == null ? 0 : this.launchSpecification().hashCode());
        hashCode = 31 * hashCode + (this.launchedAvailabilityZone() == null ? 0 : this.launchedAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.productDescription() == null ? 0 : this.productDescription().hashCode());
        hashCode = 31 * hashCode + (this.spotInstanceRequestId() == null ? 0 : this.spotInstanceRequestId().hashCode());
        hashCode = 31 * hashCode + (this.spotPrice() == null ? 0 : this.spotPrice().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.validFrom() == null ? 0 : this.validFrom().hashCode());
        hashCode = 31 * hashCode + (this.validUntil() == null ? 0 : this.validUntil().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotInstanceRequest)) {
            return false;
        }
        SpotInstanceRequest other = (SpotInstanceRequest)obj;
        if (other.actualBlockHourlyPrice() == null ^ this.actualBlockHourlyPrice() == null) {
            return false;
        }
        if (other.actualBlockHourlyPrice() != null && !other.actualBlockHourlyPrice().equals(this.actualBlockHourlyPrice())) {
            return false;
        }
        if (other.availabilityZoneGroup() == null ^ this.availabilityZoneGroup() == null) {
            return false;
        }
        if (other.availabilityZoneGroup() != null && !other.availabilityZoneGroup().equals(this.availabilityZoneGroup())) {
            return false;
        }
        if (other.blockDurationMinutes() == null ^ this.blockDurationMinutes() == null) {
            return false;
        }
        if (other.blockDurationMinutes() != null && !other.blockDurationMinutes().equals(this.blockDurationMinutes())) {
            return false;
        }
        if (other.createTime() == null ^ this.createTime() == null) {
            return false;
        }
        if (other.createTime() != null && !other.createTime().equals(this.createTime())) {
            return false;
        }
        if (other.fault() == null ^ this.fault() == null) {
            return false;
        }
        if (other.fault() != null && !other.fault().equals(this.fault())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.launchGroup() == null ^ this.launchGroup() == null) {
            return false;
        }
        if (other.launchGroup() != null && !other.launchGroup().equals(this.launchGroup())) {
            return false;
        }
        if (other.launchSpecification() == null ^ this.launchSpecification() == null) {
            return false;
        }
        if (other.launchSpecification() != null && !other.launchSpecification().equals(this.launchSpecification())) {
            return false;
        }
        if (other.launchedAvailabilityZone() == null ^ this.launchedAvailabilityZone() == null) {
            return false;
        }
        if (other.launchedAvailabilityZone() != null && !other.launchedAvailabilityZone().equals(this.launchedAvailabilityZone())) {
            return false;
        }
        if (other.productDescription() == null ^ this.productDescription() == null) {
            return false;
        }
        if (other.productDescription() != null && !other.productDescription().equals(this.productDescription())) {
            return false;
        }
        if (other.spotInstanceRequestId() == null ^ this.spotInstanceRequestId() == null) {
            return false;
        }
        if (other.spotInstanceRequestId() != null && !other.spotInstanceRequestId().equals(this.spotInstanceRequestId())) {
            return false;
        }
        if (other.spotPrice() == null ^ this.spotPrice() == null) {
            return false;
        }
        if (other.spotPrice() != null && !other.spotPrice().equals(this.spotPrice())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.validFrom() == null ^ this.validFrom() == null) {
            return false;
        }
        if (other.validFrom() != null && !other.validFrom().equals(this.validFrom())) {
            return false;
        }
        if (other.validUntil() == null ^ this.validUntil() == null) {
            return false;
        }
        return other.validUntil() == null || other.validUntil().equals(this.validUntil());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.actualBlockHourlyPrice() != null) {
            sb.append("ActualBlockHourlyPrice: ").append(this.actualBlockHourlyPrice()).append(",");
        }
        if (this.availabilityZoneGroup() != null) {
            sb.append("AvailabilityZoneGroup: ").append(this.availabilityZoneGroup()).append(",");
        }
        if (this.blockDurationMinutes() != null) {
            sb.append("BlockDurationMinutes: ").append(this.blockDurationMinutes()).append(",");
        }
        if (this.createTime() != null) {
            sb.append("CreateTime: ").append(this.createTime()).append(",");
        }
        if (this.fault() != null) {
            sb.append("Fault: ").append(this.fault()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.launchGroup() != null) {
            sb.append("LaunchGroup: ").append(this.launchGroup()).append(",");
        }
        if (this.launchSpecification() != null) {
            sb.append("LaunchSpecification: ").append(this.launchSpecification()).append(",");
        }
        if (this.launchedAvailabilityZone() != null) {
            sb.append("LaunchedAvailabilityZone: ").append(this.launchedAvailabilityZone()).append(",");
        }
        if (this.productDescription() != null) {
            sb.append("ProductDescription: ").append(this.productDescription()).append(",");
        }
        if (this.spotInstanceRequestId() != null) {
            sb.append("SpotInstanceRequestId: ").append(this.spotInstanceRequestId()).append(",");
        }
        if (this.spotPrice() != null) {
            sb.append("SpotPrice: ").append(this.spotPrice()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.validFrom() != null) {
            sb.append("ValidFrom: ").append(this.validFrom()).append(",");
        }
        if (this.validUntil() != null) {
            sb.append("ValidUntil: ").append(this.validUntil()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String actualBlockHourlyPrice;
        private String availabilityZoneGroup;
        private Integer blockDurationMinutes;
        private Instant createTime;
        private SpotInstanceStateFault fault;
        private String instanceId;
        private String launchGroup;
        private LaunchSpecification launchSpecification;
        private String launchedAvailabilityZone;
        private String productDescription;
        private String spotInstanceRequestId;
        private String spotPrice;
        private String state;
        private SpotInstanceStatus status;
        private List<Tag> tags;
        private String type;
        private Instant validFrom;
        private Instant validUntil;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotInstanceRequest model) {
            this.setActualBlockHourlyPrice(model.actualBlockHourlyPrice);
            this.setAvailabilityZoneGroup(model.availabilityZoneGroup);
            this.setBlockDurationMinutes(model.blockDurationMinutes);
            this.setCreateTime(model.createTime);
            this.setFault(model.fault);
            this.setInstanceId(model.instanceId);
            this.setLaunchGroup(model.launchGroup);
            this.setLaunchSpecification(model.launchSpecification);
            this.setLaunchedAvailabilityZone(model.launchedAvailabilityZone);
            this.setProductDescription(model.productDescription);
            this.setSpotInstanceRequestId(model.spotInstanceRequestId);
            this.setSpotPrice(model.spotPrice);
            this.setState(model.state);
            this.setStatus(model.status);
            this.setTags(model.tags);
            this.setType(model.type);
            this.setValidFrom(model.validFrom);
            this.setValidUntil(model.validUntil);
        }

        public final String getActualBlockHourlyPrice() {
            return this.actualBlockHourlyPrice;
        }

        @Override
        public final Builder actualBlockHourlyPrice(String actualBlockHourlyPrice) {
            this.actualBlockHourlyPrice = actualBlockHourlyPrice;
            return this;
        }

        public final void setActualBlockHourlyPrice(String actualBlockHourlyPrice) {
            this.actualBlockHourlyPrice = actualBlockHourlyPrice;
        }

        public final String getAvailabilityZoneGroup() {
            return this.availabilityZoneGroup;
        }

        @Override
        public final Builder availabilityZoneGroup(String availabilityZoneGroup) {
            this.availabilityZoneGroup = availabilityZoneGroup;
            return this;
        }

        public final void setAvailabilityZoneGroup(String availabilityZoneGroup) {
            this.availabilityZoneGroup = availabilityZoneGroup;
        }

        public final Integer getBlockDurationMinutes() {
            return this.blockDurationMinutes;
        }

        @Override
        public final Builder blockDurationMinutes(Integer blockDurationMinutes) {
            this.blockDurationMinutes = blockDurationMinutes;
            return this;
        }

        public final void setBlockDurationMinutes(Integer blockDurationMinutes) {
            this.blockDurationMinutes = blockDurationMinutes;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final SpotInstanceStateFault getFault() {
            return this.fault;
        }

        @Override
        public final Builder fault(SpotInstanceStateFault fault) {
            this.fault = fault;
            return this;
        }

        public final void setFault(SpotInstanceStateFault fault) {
            this.fault = fault;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getLaunchGroup() {
            return this.launchGroup;
        }

        @Override
        public final Builder launchGroup(String launchGroup) {
            this.launchGroup = launchGroup;
            return this;
        }

        public final void setLaunchGroup(String launchGroup) {
            this.launchGroup = launchGroup;
        }

        public final LaunchSpecification getLaunchSpecification() {
            return this.launchSpecification;
        }

        @Override
        public final Builder launchSpecification(LaunchSpecification launchSpecification) {
            this.launchSpecification = launchSpecification;
            return this;
        }

        public final void setLaunchSpecification(LaunchSpecification launchSpecification) {
            this.launchSpecification = launchSpecification;
        }

        public final String getLaunchedAvailabilityZone() {
            return this.launchedAvailabilityZone;
        }

        @Override
        public final Builder launchedAvailabilityZone(String launchedAvailabilityZone) {
            this.launchedAvailabilityZone = launchedAvailabilityZone;
            return this;
        }

        public final void setLaunchedAvailabilityZone(String launchedAvailabilityZone) {
            this.launchedAvailabilityZone = launchedAvailabilityZone;
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        @Override
        public final Builder productDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription.toString());
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final String getSpotInstanceRequestId() {
            return this.spotInstanceRequestId;
        }

        @Override
        public final Builder spotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
            return this;
        }

        public final void setSpotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
        }

        public final String getSpotPrice() {
            return this.spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SpotInstanceState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final SpotInstanceStatus getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(SpotInstanceStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(SpotInstanceStatus status) {
            this.status = status;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SpotInstanceType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getValidFrom() {
            return this.validFrom;
        }

        @Override
        public final Builder validFrom(Instant validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        public final void setValidFrom(Instant validFrom) {
            this.validFrom = validFrom;
        }

        public final Instant getValidUntil() {
            return this.validUntil;
        }

        @Override
        public final Builder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public final void setValidUntil(Instant validUntil) {
            this.validUntil = validUntil;
        }

        public SpotInstanceRequest build() {
            return new SpotInstanceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SpotInstanceRequest> {
        public Builder actualBlockHourlyPrice(String var1);

        public Builder availabilityZoneGroup(String var1);

        public Builder blockDurationMinutes(Integer var1);

        public Builder createTime(Instant var1);

        public Builder fault(SpotInstanceStateFault var1);

        public Builder instanceId(String var1);

        public Builder launchGroup(String var1);

        public Builder launchSpecification(LaunchSpecification var1);

        public Builder launchedAvailabilityZone(String var1);

        public Builder productDescription(String var1);

        public Builder productDescription(RIProductDescription var1);

        public Builder spotInstanceRequestId(String var1);

        public Builder spotPrice(String var1);

        public Builder state(String var1);

        public Builder state(SpotInstanceState var1);

        public Builder status(SpotInstanceStatus var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder type(String var1);

        public Builder type(SpotInstanceType var1);

        public Builder validFrom(Instant var1);

        public Builder validUntil(Instant var1);
    }
}

