/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.AllocationStrategy;
import software.amazon.awssdk.services.ec2.model.ExcessCapacityTerminationPolicy;
import software.amazon.awssdk.services.ec2.model.FleetType;
import software.amazon.awssdk.services.ec2.model.LaunchSpecsListCopier;
import software.amazon.awssdk.services.ec2.model.SpotFleetLaunchSpecification;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SpotFleetRequestConfigData
implements ToCopyableBuilder<Builder, SpotFleetRequestConfigData> {
    private final String allocationStrategy;
    private final String clientToken;
    private final String excessCapacityTerminationPolicy;
    private final Double fulfilledCapacity;
    private final String iamFleetRole;
    private final List<SpotFleetLaunchSpecification> launchSpecifications;
    private final String spotPrice;
    private final Integer targetCapacity;
    private final Boolean terminateInstancesWithExpiration;
    private final String type;
    private final Instant validFrom;
    private final Instant validUntil;
    private final Boolean replaceUnhealthyInstances;

    private SpotFleetRequestConfigData(BuilderImpl builder) {
        this.allocationStrategy = builder.allocationStrategy;
        this.clientToken = builder.clientToken;
        this.excessCapacityTerminationPolicy = builder.excessCapacityTerminationPolicy;
        this.fulfilledCapacity = builder.fulfilledCapacity;
        this.iamFleetRole = builder.iamFleetRole;
        this.launchSpecifications = builder.launchSpecifications;
        this.spotPrice = builder.spotPrice;
        this.targetCapacity = builder.targetCapacity;
        this.terminateInstancesWithExpiration = builder.terminateInstancesWithExpiration;
        this.type = builder.type;
        this.validFrom = builder.validFrom;
        this.validUntil = builder.validUntil;
        this.replaceUnhealthyInstances = builder.replaceUnhealthyInstances;
    }

    public String allocationStrategy() {
        return this.allocationStrategy;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String excessCapacityTerminationPolicy() {
        return this.excessCapacityTerminationPolicy;
    }

    public Double fulfilledCapacity() {
        return this.fulfilledCapacity;
    }

    public String iamFleetRole() {
        return this.iamFleetRole;
    }

    public List<SpotFleetLaunchSpecification> launchSpecifications() {
        return this.launchSpecifications;
    }

    public String spotPrice() {
        return this.spotPrice;
    }

    public Integer targetCapacity() {
        return this.targetCapacity;
    }

    public Boolean terminateInstancesWithExpiration() {
        return this.terminateInstancesWithExpiration;
    }

    public String type() {
        return this.type;
    }

    public Instant validFrom() {
        return this.validFrom;
    }

    public Instant validUntil() {
        return this.validUntil;
    }

    public Boolean replaceUnhealthyInstances() {
        return this.replaceUnhealthyInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.allocationStrategy() == null ? 0 : this.allocationStrategy().hashCode());
        hashCode = 31 * hashCode + (this.clientToken() == null ? 0 : this.clientToken().hashCode());
        hashCode = 31 * hashCode + (this.excessCapacityTerminationPolicy() == null ? 0 : this.excessCapacityTerminationPolicy().hashCode());
        hashCode = 31 * hashCode + (this.fulfilledCapacity() == null ? 0 : this.fulfilledCapacity().hashCode());
        hashCode = 31 * hashCode + (this.iamFleetRole() == null ? 0 : this.iamFleetRole().hashCode());
        hashCode = 31 * hashCode + (this.launchSpecifications() == null ? 0 : this.launchSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.spotPrice() == null ? 0 : this.spotPrice().hashCode());
        hashCode = 31 * hashCode + (this.targetCapacity() == null ? 0 : this.targetCapacity().hashCode());
        hashCode = 31 * hashCode + (this.terminateInstancesWithExpiration() == null ? 0 : this.terminateInstancesWithExpiration().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.validFrom() == null ? 0 : this.validFrom().hashCode());
        hashCode = 31 * hashCode + (this.validUntil() == null ? 0 : this.validUntil().hashCode());
        hashCode = 31 * hashCode + (this.replaceUnhealthyInstances() == null ? 0 : this.replaceUnhealthyInstances().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotFleetRequestConfigData)) {
            return false;
        }
        SpotFleetRequestConfigData other = (SpotFleetRequestConfigData)obj;
        if (other.allocationStrategy() == null ^ this.allocationStrategy() == null) {
            return false;
        }
        if (other.allocationStrategy() != null && !other.allocationStrategy().equals(this.allocationStrategy())) {
            return false;
        }
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.excessCapacityTerminationPolicy() == null ^ this.excessCapacityTerminationPolicy() == null) {
            return false;
        }
        if (other.excessCapacityTerminationPolicy() != null && !other.excessCapacityTerminationPolicy().equals(this.excessCapacityTerminationPolicy())) {
            return false;
        }
        if (other.fulfilledCapacity() == null ^ this.fulfilledCapacity() == null) {
            return false;
        }
        if (other.fulfilledCapacity() != null && !other.fulfilledCapacity().equals(this.fulfilledCapacity())) {
            return false;
        }
        if (other.iamFleetRole() == null ^ this.iamFleetRole() == null) {
            return false;
        }
        if (other.iamFleetRole() != null && !other.iamFleetRole().equals(this.iamFleetRole())) {
            return false;
        }
        if (other.launchSpecifications() == null ^ this.launchSpecifications() == null) {
            return false;
        }
        if (other.launchSpecifications() != null && !other.launchSpecifications().equals(this.launchSpecifications())) {
            return false;
        }
        if (other.spotPrice() == null ^ this.spotPrice() == null) {
            return false;
        }
        if (other.spotPrice() != null && !other.spotPrice().equals(this.spotPrice())) {
            return false;
        }
        if (other.targetCapacity() == null ^ this.targetCapacity() == null) {
            return false;
        }
        if (other.targetCapacity() != null && !other.targetCapacity().equals(this.targetCapacity())) {
            return false;
        }
        if (other.terminateInstancesWithExpiration() == null ^ this.terminateInstancesWithExpiration() == null) {
            return false;
        }
        if (other.terminateInstancesWithExpiration() != null && !other.terminateInstancesWithExpiration().equals(this.terminateInstancesWithExpiration())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.validFrom() == null ^ this.validFrom() == null) {
            return false;
        }
        if (other.validFrom() != null && !other.validFrom().equals(this.validFrom())) {
            return false;
        }
        if (other.validUntil() == null ^ this.validUntil() == null) {
            return false;
        }
        if (other.validUntil() != null && !other.validUntil().equals(this.validUntil())) {
            return false;
        }
        if (other.replaceUnhealthyInstances() == null ^ this.replaceUnhealthyInstances() == null) {
            return false;
        }
        return other.replaceUnhealthyInstances() == null || other.replaceUnhealthyInstances().equals(this.replaceUnhealthyInstances());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allocationStrategy() != null) {
            sb.append("AllocationStrategy: ").append(this.allocationStrategy()).append(",");
        }
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.excessCapacityTerminationPolicy() != null) {
            sb.append("ExcessCapacityTerminationPolicy: ").append(this.excessCapacityTerminationPolicy()).append(",");
        }
        if (this.fulfilledCapacity() != null) {
            sb.append("FulfilledCapacity: ").append(this.fulfilledCapacity()).append(",");
        }
        if (this.iamFleetRole() != null) {
            sb.append("IamFleetRole: ").append(this.iamFleetRole()).append(",");
        }
        if (this.launchSpecifications() != null) {
            sb.append("LaunchSpecifications: ").append(this.launchSpecifications()).append(",");
        }
        if (this.spotPrice() != null) {
            sb.append("SpotPrice: ").append(this.spotPrice()).append(",");
        }
        if (this.targetCapacity() != null) {
            sb.append("TargetCapacity: ").append(this.targetCapacity()).append(",");
        }
        if (this.terminateInstancesWithExpiration() != null) {
            sb.append("TerminateInstancesWithExpiration: ").append(this.terminateInstancesWithExpiration()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.validFrom() != null) {
            sb.append("ValidFrom: ").append(this.validFrom()).append(",");
        }
        if (this.validUntil() != null) {
            sb.append("ValidUntil: ").append(this.validUntil()).append(",");
        }
        if (this.replaceUnhealthyInstances() != null) {
            sb.append("ReplaceUnhealthyInstances: ").append(this.replaceUnhealthyInstances()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String allocationStrategy;
        private String clientToken;
        private String excessCapacityTerminationPolicy;
        private Double fulfilledCapacity;
        private String iamFleetRole;
        private List<SpotFleetLaunchSpecification> launchSpecifications;
        private String spotPrice;
        private Integer targetCapacity;
        private Boolean terminateInstancesWithExpiration;
        private String type;
        private Instant validFrom;
        private Instant validUntil;
        private Boolean replaceUnhealthyInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotFleetRequestConfigData model) {
            this.setAllocationStrategy(model.allocationStrategy);
            this.setClientToken(model.clientToken);
            this.setExcessCapacityTerminationPolicy(model.excessCapacityTerminationPolicy);
            this.setFulfilledCapacity(model.fulfilledCapacity);
            this.setIamFleetRole(model.iamFleetRole);
            this.setLaunchSpecifications(model.launchSpecifications);
            this.setSpotPrice(model.spotPrice);
            this.setTargetCapacity(model.targetCapacity);
            this.setTerminateInstancesWithExpiration(model.terminateInstancesWithExpiration);
            this.setType(model.type);
            this.setValidFrom(model.validFrom);
            this.setValidUntil(model.validUntil);
            this.setReplaceUnhealthyInstances(model.replaceUnhealthyInstances);
        }

        public final String getAllocationStrategy() {
            return this.allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(AllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy.toString());
            return this;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getExcessCapacityTerminationPolicy() {
            return this.excessCapacityTerminationPolicy;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
            return this;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy(excessCapacityTerminationPolicy.toString());
            return this;
        }

        public final void setExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
        }

        public final Double getFulfilledCapacity() {
            return this.fulfilledCapacity;
        }

        @Override
        public final Builder fulfilledCapacity(Double fulfilledCapacity) {
            this.fulfilledCapacity = fulfilledCapacity;
            return this;
        }

        public final void setFulfilledCapacity(Double fulfilledCapacity) {
            this.fulfilledCapacity = fulfilledCapacity;
        }

        public final String getIamFleetRole() {
            return this.iamFleetRole;
        }

        @Override
        public final Builder iamFleetRole(String iamFleetRole) {
            this.iamFleetRole = iamFleetRole;
            return this;
        }

        public final void setIamFleetRole(String iamFleetRole) {
            this.iamFleetRole = iamFleetRole;
        }

        public final Collection<SpotFleetLaunchSpecification> getLaunchSpecifications() {
            return this.launchSpecifications;
        }

        @Override
        public final Builder launchSpecifications(Collection<SpotFleetLaunchSpecification> launchSpecifications) {
            this.launchSpecifications = LaunchSpecsListCopier.copy(launchSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchSpecifications(SpotFleetLaunchSpecification ... launchSpecifications) {
            this.launchSpecifications(Arrays.asList(launchSpecifications));
            return this;
        }

        public final void setLaunchSpecifications(Collection<SpotFleetLaunchSpecification> launchSpecifications) {
            this.launchSpecifications = LaunchSpecsListCopier.copy(launchSpecifications);
        }

        public final String getSpotPrice() {
            return this.spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        public final Integer getTargetCapacity() {
            return this.targetCapacity;
        }

        @Override
        public final Builder targetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
            return this;
        }

        public final void setTargetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
        }

        public final Boolean getTerminateInstancesWithExpiration() {
            return this.terminateInstancesWithExpiration;
        }

        @Override
        public final Builder terminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
            return this;
        }

        public final void setTerminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FleetType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getValidFrom() {
            return this.validFrom;
        }

        @Override
        public final Builder validFrom(Instant validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        public final void setValidFrom(Instant validFrom) {
            this.validFrom = validFrom;
        }

        public final Instant getValidUntil() {
            return this.validUntil;
        }

        @Override
        public final Builder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public final void setValidUntil(Instant validUntil) {
            this.validUntil = validUntil;
        }

        public final Boolean getReplaceUnhealthyInstances() {
            return this.replaceUnhealthyInstances;
        }

        @Override
        public final Builder replaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
            return this;
        }

        public final void setReplaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
        }

        public SpotFleetRequestConfigData build() {
            return new SpotFleetRequestConfigData(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SpotFleetRequestConfigData> {
        public Builder allocationStrategy(String var1);

        public Builder allocationStrategy(AllocationStrategy var1);

        public Builder clientToken(String var1);

        public Builder excessCapacityTerminationPolicy(String var1);

        public Builder excessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy var1);

        public Builder fulfilledCapacity(Double var1);

        public Builder iamFleetRole(String var1);

        public Builder launchSpecifications(Collection<SpotFleetLaunchSpecification> var1);

        public Builder launchSpecifications(SpotFleetLaunchSpecification ... var1);

        public Builder spotPrice(String var1);

        public Builder targetCapacity(Integer var1);

        public Builder terminateInstancesWithExpiration(Boolean var1);

        public Builder type(String var1);

        public Builder type(FleetType var1);

        public Builder validFrom(Instant var1);

        public Builder validUntil(Instant var1);

        public Builder replaceUnhealthyInstances(Boolean var1);
    }
}

