/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.RequestHostIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReleaseHostsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ReleaseHostsRequest> {
    private final List<String> hostIds;

    private ReleaseHostsRequest(BuilderImpl builder) {
        this.hostIds = builder.hostIds;
    }

    public List<String> hostIds() {
        return this.hostIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.hostIds() == null ? 0 : this.hostIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReleaseHostsRequest)) {
            return false;
        }
        ReleaseHostsRequest other = (ReleaseHostsRequest)((Object)obj);
        if (other.hostIds() == null ^ this.hostIds() == null) {
            return false;
        }
        return other.hostIds() == null || other.hostIds().equals(this.hostIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostIds() != null) {
            sb.append("HostIds: ").append(this.hostIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> hostIds;

        private BuilderImpl() {
        }

        private BuilderImpl(ReleaseHostsRequest model) {
            this.setHostIds(model.hostIds);
        }

        public final Collection<String> getHostIds() {
            return this.hostIds;
        }

        @Override
        public final Builder hostIds(Collection<String> hostIds) {
            this.hostIds = RequestHostIdListCopier.copy(hostIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIds(String ... hostIds) {
            this.hostIds(Arrays.asList(hostIds));
            return this;
        }

        public final void setHostIds(Collection<String> hostIds) {
            this.hostIds = RequestHostIdListCopier.copy(hostIds);
        }

        public ReleaseHostsRequest build() {
            return new ReleaseHostsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReleaseHostsRequest> {
        public Builder hostIds(Collection<String> var1);

        public Builder hostIds(String ... var1);
    }
}

