/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Region
implements ToCopyableBuilder<Builder, Region> {
    private final String endpoint;
    private final String regionName;

    private Region(BuilderImpl builder) {
        this.endpoint = builder.endpoint;
        this.regionName = builder.regionName;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String regionName() {
        return this.regionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.endpoint() == null ? 0 : this.endpoint().hashCode());
        hashCode = 31 * hashCode + (this.regionName() == null ? 0 : this.regionName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Region)) {
            return false;
        }
        Region other = (Region)obj;
        if (other.endpoint() == null ^ this.endpoint() == null) {
            return false;
        }
        if (other.endpoint() != null && !other.endpoint().equals(this.endpoint())) {
            return false;
        }
        if (other.regionName() == null ^ this.regionName() == null) {
            return false;
        }
        return other.regionName() == null || other.regionName().equals(this.regionName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.endpoint() != null) {
            sb.append("Endpoint: ").append(this.endpoint()).append(",");
        }
        if (this.regionName() != null) {
            sb.append("RegionName: ").append(this.regionName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String endpoint;
        private String regionName;

        private BuilderImpl() {
        }

        private BuilderImpl(Region model) {
            this.setEndpoint(model.endpoint);
            this.setRegionName(model.regionName);
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getRegionName() {
            return this.regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public Region build() {
            return new Region(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Region> {
        public Builder endpoint(String var1);

        public Builder regionName(String var1);
    }
}

