/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.IpRange;
import software.amazon.awssdk.services.ec2.model.IpRangeListCopier;
import software.amazon.awssdk.services.ec2.model.Ipv6Range;
import software.amazon.awssdk.services.ec2.model.Ipv6RangeListCopier;
import software.amazon.awssdk.services.ec2.model.PrefixListId;
import software.amazon.awssdk.services.ec2.model.PrefixListIdListCopier;
import software.amazon.awssdk.services.ec2.model.UserIdGroupPair;
import software.amazon.awssdk.services.ec2.model.UserIdGroupPairListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IpPermission
implements ToCopyableBuilder<Builder, IpPermission> {
    private final Integer fromPort;
    private final String ipProtocol;
    private final List<Ipv6Range> ipv6Ranges;
    private final List<PrefixListId> prefixListIds;
    private final Integer toPort;
    private final List<UserIdGroupPair> userIdGroupPairs;
    private final List<IpRange> ipv4Ranges;

    private IpPermission(BuilderImpl builder) {
        this.fromPort = builder.fromPort;
        this.ipProtocol = builder.ipProtocol;
        this.ipv6Ranges = builder.ipv6Ranges;
        this.prefixListIds = builder.prefixListIds;
        this.toPort = builder.toPort;
        this.userIdGroupPairs = builder.userIdGroupPairs;
        this.ipv4Ranges = builder.ipv4Ranges;
    }

    public Integer fromPort() {
        return this.fromPort;
    }

    public String ipProtocol() {
        return this.ipProtocol;
    }

    public List<Ipv6Range> ipv6Ranges() {
        return this.ipv6Ranges;
    }

    public List<PrefixListId> prefixListIds() {
        return this.prefixListIds;
    }

    public Integer toPort() {
        return this.toPort;
    }

    public List<UserIdGroupPair> userIdGroupPairs() {
        return this.userIdGroupPairs;
    }

    public List<IpRange> ipv4Ranges() {
        return this.ipv4Ranges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fromPort() == null ? 0 : this.fromPort().hashCode());
        hashCode = 31 * hashCode + (this.ipProtocol() == null ? 0 : this.ipProtocol().hashCode());
        hashCode = 31 * hashCode + (this.ipv6Ranges() == null ? 0 : this.ipv6Ranges().hashCode());
        hashCode = 31 * hashCode + (this.prefixListIds() == null ? 0 : this.prefixListIds().hashCode());
        hashCode = 31 * hashCode + (this.toPort() == null ? 0 : this.toPort().hashCode());
        hashCode = 31 * hashCode + (this.userIdGroupPairs() == null ? 0 : this.userIdGroupPairs().hashCode());
        hashCode = 31 * hashCode + (this.ipv4Ranges() == null ? 0 : this.ipv4Ranges().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpPermission)) {
            return false;
        }
        IpPermission other = (IpPermission)obj;
        if (other.fromPort() == null ^ this.fromPort() == null) {
            return false;
        }
        if (other.fromPort() != null && !other.fromPort().equals(this.fromPort())) {
            return false;
        }
        if (other.ipProtocol() == null ^ this.ipProtocol() == null) {
            return false;
        }
        if (other.ipProtocol() != null && !other.ipProtocol().equals(this.ipProtocol())) {
            return false;
        }
        if (other.ipv6Ranges() == null ^ this.ipv6Ranges() == null) {
            return false;
        }
        if (other.ipv6Ranges() != null && !other.ipv6Ranges().equals(this.ipv6Ranges())) {
            return false;
        }
        if (other.prefixListIds() == null ^ this.prefixListIds() == null) {
            return false;
        }
        if (other.prefixListIds() != null && !other.prefixListIds().equals(this.prefixListIds())) {
            return false;
        }
        if (other.toPort() == null ^ this.toPort() == null) {
            return false;
        }
        if (other.toPort() != null && !other.toPort().equals(this.toPort())) {
            return false;
        }
        if (other.userIdGroupPairs() == null ^ this.userIdGroupPairs() == null) {
            return false;
        }
        if (other.userIdGroupPairs() != null && !other.userIdGroupPairs().equals(this.userIdGroupPairs())) {
            return false;
        }
        if (other.ipv4Ranges() == null ^ this.ipv4Ranges() == null) {
            return false;
        }
        return other.ipv4Ranges() == null || other.ipv4Ranges().equals(this.ipv4Ranges());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fromPort() != null) {
            sb.append("FromPort: ").append(this.fromPort()).append(",");
        }
        if (this.ipProtocol() != null) {
            sb.append("IpProtocol: ").append(this.ipProtocol()).append(",");
        }
        if (this.ipv6Ranges() != null) {
            sb.append("Ipv6Ranges: ").append(this.ipv6Ranges()).append(",");
        }
        if (this.prefixListIds() != null) {
            sb.append("PrefixListIds: ").append(this.prefixListIds()).append(",");
        }
        if (this.toPort() != null) {
            sb.append("ToPort: ").append(this.toPort()).append(",");
        }
        if (this.userIdGroupPairs() != null) {
            sb.append("UserIdGroupPairs: ").append(this.userIdGroupPairs()).append(",");
        }
        if (this.ipv4Ranges() != null) {
            sb.append("Ipv4Ranges: ").append(this.ipv4Ranges()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer fromPort;
        private String ipProtocol;
        private List<Ipv6Range> ipv6Ranges;
        private List<PrefixListId> prefixListIds;
        private Integer toPort;
        private List<UserIdGroupPair> userIdGroupPairs;
        private List<IpRange> ipv4Ranges;

        private BuilderImpl() {
        }

        private BuilderImpl(IpPermission model) {
            this.setFromPort(model.fromPort);
            this.setIpProtocol(model.ipProtocol);
            this.setIpv6Ranges(model.ipv6Ranges);
            this.setPrefixListIds(model.prefixListIds);
            this.setToPort(model.toPort);
            this.setUserIdGroupPairs(model.userIdGroupPairs);
            this.setIpv4Ranges(model.ipv4Ranges);
        }

        public final Integer getFromPort() {
            return this.fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final String getIpProtocol() {
            return this.ipProtocol;
        }

        @Override
        public final Builder ipProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public final void setIpProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
        }

        public final Collection<Ipv6Range> getIpv6Ranges() {
            return this.ipv6Ranges;
        }

        @Override
        public final Builder ipv6Ranges(Collection<Ipv6Range> ipv6Ranges) {
            this.ipv6Ranges = Ipv6RangeListCopier.copy(ipv6Ranges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Ranges(Ipv6Range ... ipv6Ranges) {
            this.ipv6Ranges(Arrays.asList(ipv6Ranges));
            return this;
        }

        public final void setIpv6Ranges(Collection<Ipv6Range> ipv6Ranges) {
            this.ipv6Ranges = Ipv6RangeListCopier.copy(ipv6Ranges);
        }

        public final Collection<PrefixListId> getPrefixListIds() {
            return this.prefixListIds;
        }

        @Override
        public final Builder prefixListIds(Collection<PrefixListId> prefixListIds) {
            this.prefixListIds = PrefixListIdListCopier.copy(prefixListIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixListIds(PrefixListId ... prefixListIds) {
            this.prefixListIds(Arrays.asList(prefixListIds));
            return this;
        }

        public final void setPrefixListIds(Collection<PrefixListId> prefixListIds) {
            this.prefixListIds = PrefixListIdListCopier.copy(prefixListIds);
        }

        public final Integer getToPort() {
            return this.toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final Collection<UserIdGroupPair> getUserIdGroupPairs() {
            return this.userIdGroupPairs;
        }

        @Override
        public final Builder userIdGroupPairs(Collection<UserIdGroupPair> userIdGroupPairs) {
            this.userIdGroupPairs = UserIdGroupPairListCopier.copy(userIdGroupPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdGroupPairs(UserIdGroupPair ... userIdGroupPairs) {
            this.userIdGroupPairs(Arrays.asList(userIdGroupPairs));
            return this;
        }

        public final void setUserIdGroupPairs(Collection<UserIdGroupPair> userIdGroupPairs) {
            this.userIdGroupPairs = UserIdGroupPairListCopier.copy(userIdGroupPairs);
        }

        public final Collection<IpRange> getIpv4Ranges() {
            return this.ipv4Ranges;
        }

        @Override
        public final Builder ipv4Ranges(Collection<IpRange> ipv4Ranges) {
            this.ipv4Ranges = IpRangeListCopier.copy(ipv4Ranges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Ranges(IpRange ... ipv4Ranges) {
            this.ipv4Ranges(Arrays.asList(ipv4Ranges));
            return this;
        }

        public final void setIpv4Ranges(Collection<IpRange> ipv4Ranges) {
            this.ipv4Ranges = IpRangeListCopier.copy(ipv4Ranges);
        }

        public IpPermission build() {
            return new IpPermission(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IpPermission> {
        public Builder fromPort(Integer var1);

        public Builder ipProtocol(String var1);

        public Builder ipv6Ranges(Collection<Ipv6Range> var1);

        public Builder ipv6Ranges(Ipv6Range ... var1);

        public Builder prefixListIds(Collection<PrefixListId> var1);

        public Builder prefixListIds(PrefixListId ... var1);

        public Builder toPort(Integer var1);

        public Builder userIdGroupPairs(Collection<UserIdGroupPair> var1);

        public Builder userIdGroupPairs(UserIdGroupPair ... var1);

        public Builder ipv4Ranges(Collection<IpRange> var1);

        public Builder ipv4Ranges(IpRange ... var1);
    }
}

