/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import software.amazon.awssdk.services.ec2.model.EventCode;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceStatusEvent
implements ToCopyableBuilder<Builder, InstanceStatusEvent> {
    private final String code;
    private final String description;
    private final Instant notAfter;
    private final Instant notBefore;

    private InstanceStatusEvent(BuilderImpl builder) {
        this.code = builder.code;
        this.description = builder.description;
        this.notAfter = builder.notAfter;
        this.notBefore = builder.notBefore;
    }

    public String code() {
        return this.code;
    }

    public String description() {
        return this.description;
    }

    public Instant notAfter() {
        return this.notAfter;
    }

    public Instant notBefore() {
        return this.notBefore;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.code() == null ? 0 : this.code().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.notAfter() == null ? 0 : this.notAfter().hashCode());
        hashCode = 31 * hashCode + (this.notBefore() == null ? 0 : this.notBefore().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStatusEvent)) {
            return false;
        }
        InstanceStatusEvent other = (InstanceStatusEvent)obj;
        if (other.code() == null ^ this.code() == null) {
            return false;
        }
        if (other.code() != null && !other.code().equals(this.code())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.notAfter() == null ^ this.notAfter() == null) {
            return false;
        }
        if (other.notAfter() != null && !other.notAfter().equals(this.notAfter())) {
            return false;
        }
        if (other.notBefore() == null ^ this.notBefore() == null) {
            return false;
        }
        return other.notBefore() == null || other.notBefore().equals(this.notBefore());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.code() != null) {
            sb.append("Code: ").append(this.code()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.notAfter() != null) {
            sb.append("NotAfter: ").append(this.notAfter()).append(",");
        }
        if (this.notBefore() != null) {
            sb.append("NotBefore: ").append(this.notBefore()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String code;
        private String description;
        private Instant notAfter;
        private Instant notBefore;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStatusEvent model) {
            this.setCode(model.code);
            this.setDescription(model.description);
            this.setNotAfter(model.notAfter);
            this.setNotBefore(model.notBefore);
        }

        public final String getCode() {
            return this.code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(EventCode code) {
            this.code(code.toString());
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getNotAfter() {
            return this.notAfter;
        }

        @Override
        public final Builder notAfter(Instant notAfter) {
            this.notAfter = notAfter;
            return this;
        }

        public final void setNotAfter(Instant notAfter) {
            this.notAfter = notAfter;
        }

        public final Instant getNotBefore() {
            return this.notBefore;
        }

        @Override
        public final Builder notBefore(Instant notBefore) {
            this.notBefore = notBefore;
            return this;
        }

        public final void setNotBefore(Instant notBefore) {
            this.notBefore = notBefore;
        }

        public InstanceStatusEvent build() {
            return new InstanceStatusEvent(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceStatusEvent> {
        public Builder code(String var1);

        public Builder code(EventCode var1);

        public Builder description(String var1);

        public Builder notAfter(Instant var1);

        public Builder notBefore(Instant var1);
    }
}

