/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.DiskImageDetail;
import software.amazon.awssdk.services.ec2.model.VolumeDetail;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImportVolumeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ImportVolumeRequest> {
    private final String availabilityZone;
    private final String description;
    private final DiskImageDetail image;
    private final VolumeDetail volume;

    private ImportVolumeRequest(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.description = builder.description;
        this.image = builder.image;
        this.volume = builder.volume;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String description() {
        return this.description;
    }

    public DiskImageDetail image() {
        return this.image;
    }

    public VolumeDetail volume() {
        return this.volume;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.image() == null ? 0 : this.image().hashCode());
        hashCode = 31 * hashCode + (this.volume() == null ? 0 : this.volume().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportVolumeRequest)) {
            return false;
        }
        ImportVolumeRequest other = (ImportVolumeRequest)((Object)obj);
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.image() == null ^ this.image() == null) {
            return false;
        }
        if (other.image() != null && !other.image().equals(this.image())) {
            return false;
        }
        if (other.volume() == null ^ this.volume() == null) {
            return false;
        }
        return other.volume() == null || other.volume().equals(this.volume());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.image() != null) {
            sb.append("Image: ").append(this.image()).append(",");
        }
        if (this.volume() != null) {
            sb.append("Volume: ").append(this.volume()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String description;
        private DiskImageDetail image;
        private VolumeDetail volume;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportVolumeRequest model) {
            this.setAvailabilityZone(model.availabilityZone);
            this.setDescription(model.description);
            this.setImage(model.image);
            this.setVolume(model.volume);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final DiskImageDetail getImage() {
            return this.image;
        }

        @Override
        public final Builder image(DiskImageDetail image) {
            this.image = image;
            return this;
        }

        public final void setImage(DiskImageDetail image) {
            this.image = image;
        }

        public final VolumeDetail getVolume() {
            return this.volume;
        }

        @Override
        public final Builder volume(VolumeDetail volume) {
            this.volume = volume;
            return this;
        }

        public final void setVolume(VolumeDetail volume) {
            this.volume = volume;
        }

        public ImportVolumeRequest build() {
            return new ImportVolumeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImportVolumeRequest> {
        public Builder availabilityZone(String var1);

        public Builder description(String var1);

        public Builder image(DiskImageDetail var1);

        public Builder volume(VolumeDetail var1);
    }
}

