/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.ImportInstanceVolumeDetailItem;
import software.amazon.awssdk.services.ec2.model.ImportInstanceVolumeDetailSetCopier;
import software.amazon.awssdk.services.ec2.model.PlatformValues;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImportInstanceTaskDetails
implements ToCopyableBuilder<Builder, ImportInstanceTaskDetails> {
    private final String description;
    private final String instanceId;
    private final String platform;
    private final List<ImportInstanceVolumeDetailItem> volumes;

    private ImportInstanceTaskDetails(BuilderImpl builder) {
        this.description = builder.description;
        this.instanceId = builder.instanceId;
        this.platform = builder.platform;
        this.volumes = builder.volumes;
    }

    public String description() {
        return this.description;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String platform() {
        return this.platform;
    }

    public List<ImportInstanceVolumeDetailItem> volumes() {
        return this.volumes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.platform() == null ? 0 : this.platform().hashCode());
        hashCode = 31 * hashCode + (this.volumes() == null ? 0 : this.volumes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportInstanceTaskDetails)) {
            return false;
        }
        ImportInstanceTaskDetails other = (ImportInstanceTaskDetails)obj;
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.platform() == null ^ this.platform() == null) {
            return false;
        }
        if (other.platform() != null && !other.platform().equals(this.platform())) {
            return false;
        }
        if (other.volumes() == null ^ this.volumes() == null) {
            return false;
        }
        return other.volumes() == null || other.volumes().equals(this.volumes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.platform() != null) {
            sb.append("Platform: ").append(this.platform()).append(",");
        }
        if (this.volumes() != null) {
            sb.append("Volumes: ").append(this.volumes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String description;
        private String instanceId;
        private String platform;
        private List<ImportInstanceVolumeDetailItem> volumes;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportInstanceTaskDetails model) {
            this.setDescription(model.description);
            this.setInstanceId(model.instanceId);
            this.setPlatform(model.platform);
            this.setVolumes(model.volumes);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformValues platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final Collection<ImportInstanceVolumeDetailItem> getVolumes() {
            return this.volumes;
        }

        @Override
        public final Builder volumes(Collection<ImportInstanceVolumeDetailItem> volumes) {
            this.volumes = ImportInstanceVolumeDetailSetCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(ImportInstanceVolumeDetailItem ... volumes) {
            this.volumes(Arrays.asList(volumes));
            return this;
        }

        public final void setVolumes(Collection<ImportInstanceVolumeDetailItem> volumes) {
            this.volumes = ImportInstanceVolumeDetailSetCopier.copy(volumes);
        }

        public ImportInstanceTaskDetails build() {
            return new ImportInstanceTaskDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImportInstanceTaskDetails> {
        public Builder description(String var1);

        public Builder instanceId(String var1);

        public Builder platform(String var1);

        public Builder platform(PlatformValues var1);

        public Builder volumes(Collection<ImportInstanceVolumeDetailItem> var1);

        public Builder volumes(ImportInstanceVolumeDetailItem ... var1);
    }
}

