/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import software.amazon.awssdk.services.ec2.model.AttachmentStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EbsInstanceBlockDevice
implements ToCopyableBuilder<Builder, EbsInstanceBlockDevice> {
    private final Instant attachTime;
    private final Boolean deleteOnTermination;
    private final String status;
    private final String volumeId;

    private EbsInstanceBlockDevice(BuilderImpl builder) {
        this.attachTime = builder.attachTime;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.status = builder.status;
        this.volumeId = builder.volumeId;
    }

    public Instant attachTime() {
        return this.attachTime;
    }

    public Boolean deleteOnTermination() {
        return this.deleteOnTermination;
    }

    public String status() {
        return this.status;
    }

    public String volumeId() {
        return this.volumeId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attachTime() == null ? 0 : this.attachTime().hashCode());
        hashCode = 31 * hashCode + (this.deleteOnTermination() == null ? 0 : this.deleteOnTermination().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.volumeId() == null ? 0 : this.volumeId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsInstanceBlockDevice)) {
            return false;
        }
        EbsInstanceBlockDevice other = (EbsInstanceBlockDevice)obj;
        if (other.attachTime() == null ^ this.attachTime() == null) {
            return false;
        }
        if (other.attachTime() != null && !other.attachTime().equals(this.attachTime())) {
            return false;
        }
        if (other.deleteOnTermination() == null ^ this.deleteOnTermination() == null) {
            return false;
        }
        if (other.deleteOnTermination() != null && !other.deleteOnTermination().equals(this.deleteOnTermination())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.volumeId() == null ^ this.volumeId() == null) {
            return false;
        }
        return other.volumeId() == null || other.volumeId().equals(this.volumeId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attachTime() != null) {
            sb.append("AttachTime: ").append(this.attachTime()).append(",");
        }
        if (this.deleteOnTermination() != null) {
            sb.append("DeleteOnTermination: ").append(this.deleteOnTermination()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.volumeId() != null) {
            sb.append("VolumeId: ").append(this.volumeId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Instant attachTime;
        private Boolean deleteOnTermination;
        private String status;
        private String volumeId;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsInstanceBlockDevice model) {
            this.setAttachTime(model.attachTime);
            this.setDeleteOnTermination(model.deleteOnTermination);
            this.setStatus(model.status);
            this.setVolumeId(model.volumeId);
        }

        public final Instant getAttachTime() {
            return this.attachTime;
        }

        @Override
        public final Builder attachTime(Instant attachTime) {
            this.attachTime = attachTime;
            return this;
        }

        public final void setAttachTime(Instant attachTime) {
            this.attachTime = attachTime;
        }

        public final Boolean getDeleteOnTermination() {
            return this.deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AttachmentStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public EbsInstanceBlockDevice build() {
            return new EbsInstanceBlockDevice(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EbsInstanceBlockDevice> {
        public Builder attachTime(Instant var1);

        public Builder deleteOnTermination(Boolean var1);

        public Builder status(String var1);

        public Builder status(AttachmentStatus var1);

        public Builder volumeId(String var1);
    }
}

