/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.DhcpConfiguration;
import software.amazon.awssdk.services.ec2.model.DhcpConfigurationListCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DhcpOptions
implements ToCopyableBuilder<Builder, DhcpOptions> {
    private final List<DhcpConfiguration> dhcpConfigurations;
    private final String dhcpOptionsId;
    private final List<Tag> tags;

    private DhcpOptions(BuilderImpl builder) {
        this.dhcpConfigurations = builder.dhcpConfigurations;
        this.dhcpOptionsId = builder.dhcpOptionsId;
        this.tags = builder.tags;
    }

    public List<DhcpConfiguration> dhcpConfigurations() {
        return this.dhcpConfigurations;
    }

    public String dhcpOptionsId() {
        return this.dhcpOptionsId;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dhcpConfigurations() == null ? 0 : this.dhcpConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.dhcpOptionsId() == null ? 0 : this.dhcpOptionsId().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DhcpOptions)) {
            return false;
        }
        DhcpOptions other = (DhcpOptions)obj;
        if (other.dhcpConfigurations() == null ^ this.dhcpConfigurations() == null) {
            return false;
        }
        if (other.dhcpConfigurations() != null && !other.dhcpConfigurations().equals(this.dhcpConfigurations())) {
            return false;
        }
        if (other.dhcpOptionsId() == null ^ this.dhcpOptionsId() == null) {
            return false;
        }
        if (other.dhcpOptionsId() != null && !other.dhcpOptionsId().equals(this.dhcpOptionsId())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dhcpConfigurations() != null) {
            sb.append("DhcpConfigurations: ").append(this.dhcpConfigurations()).append(",");
        }
        if (this.dhcpOptionsId() != null) {
            sb.append("DhcpOptionsId: ").append(this.dhcpOptionsId()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<DhcpConfiguration> dhcpConfigurations;
        private String dhcpOptionsId;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(DhcpOptions model) {
            this.setDhcpConfigurations(model.dhcpConfigurations);
            this.setDhcpOptionsId(model.dhcpOptionsId);
            this.setTags(model.tags);
        }

        public final Collection<DhcpConfiguration> getDhcpConfigurations() {
            return this.dhcpConfigurations;
        }

        @Override
        public final Builder dhcpConfigurations(Collection<DhcpConfiguration> dhcpConfigurations) {
            this.dhcpConfigurations = DhcpConfigurationListCopier.copy(dhcpConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpConfigurations(DhcpConfiguration ... dhcpConfigurations) {
            this.dhcpConfigurations(Arrays.asList(dhcpConfigurations));
            return this;
        }

        public final void setDhcpConfigurations(Collection<DhcpConfiguration> dhcpConfigurations) {
            this.dhcpConfigurations = DhcpConfigurationListCopier.copy(dhcpConfigurations);
        }

        public final String getDhcpOptionsId() {
            return this.dhcpOptionsId;
        }

        @Override
        public final Builder dhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
            return this;
        }

        public final void setDhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        public DhcpOptions build() {
            return new DhcpOptions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DhcpOptions> {
        public Builder dhcpConfigurations(Collection<DhcpConfiguration> var1);

        public Builder dhcpConfigurations(DhcpConfiguration ... var1);

        public Builder dhcpOptionsId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

