/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.RegionNameStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeRegionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeRegionsRequest> {
    private final List<Filter> filters;
    private final List<String> regionNames;

    private DescribeRegionsRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.regionNames = builder.regionNames;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public List<String> regionNames() {
        return this.regionNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.regionNames() == null ? 0 : this.regionNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegionsRequest)) {
            return false;
        }
        DescribeRegionsRequest other = (DescribeRegionsRequest)((Object)obj);
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.regionNames() == null ^ this.regionNames() == null) {
            return false;
        }
        return other.regionNames() == null || other.regionNames().equals(this.regionNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.regionNames() != null) {
            sb.append("RegionNames: ").append(this.regionNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private List<String> regionNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegionsRequest model) {
            this.setFilters(model.filters);
            this.setRegionNames(model.regionNames);
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        public final Collection<String> getRegionNames() {
            return this.regionNames;
        }

        @Override
        public final Builder regionNames(Collection<String> regionNames) {
            this.regionNames = RegionNameStringListCopier.copy(regionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionNames(String ... regionNames) {
            this.regionNames(Arrays.asList(regionNames));
            return this;
        }

        public final void setRegionNames(Collection<String> regionNames) {
            this.regionNames = RegionNameStringListCopier.copy(regionNames);
        }

        public DescribeRegionsRequest build() {
            return new DescribeRegionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeRegionsRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder regionNames(Collection<String> var1);

        public Builder regionNames(String ... var1);
    }
}

