/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.waiters;

import com.fasterxml.jackson.databind.JsonNode;
import io.burt.jmespath.Expression;
import io.burt.jmespath.jackson.JacksonRuntime;
import java.io.IOException;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse;
import software.amazon.awssdk.waiters.AcceptorPathMatcher;
import software.amazon.awssdk.waiters.ObjectMapperSingleton;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterState;

@SdkInternalApi
class InstanceStatusOk {
    InstanceStatusOk() {
    }

    static class IsInvalidInstanceIDNotFoundMatcher
    extends WaiterAcceptor<DescribeInstanceStatusResponse> {
        IsInvalidInstanceIDNotFoundMatcher() {
        }

        public boolean matches(AmazonServiceException e) {
            return "InvalidInstanceID.NotFound".equals(e.getErrorCode());
        }

        public WaiterState getState() {
            return WaiterState.RETRY;
        }
    }

    static class IsOkMatcher
    extends WaiterAcceptor<DescribeInstanceStatusResponse> {
        private static final JsonNode EXPECTED_RESULT;
        private static final Expression<JsonNode> AST;

        IsOkMatcher() {
        }

        public boolean matches(DescribeInstanceStatusResponse result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)AST.search((Object)queryNode);
            return AcceptorPathMatcher.pathAll((JsonNode)EXPECTED_RESULT, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                EXPECTED_RESULT = ObjectMapperSingleton.getObjectMapper().readTree("\"ok\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            AST = new JacksonRuntime().compile("instanceStatuses[].instanceStatus.status");
        }
    }
}

