/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeRequest;
import software.amazon.awssdk.util.StringUtils;

public class ModifyVolumeRequestMarshaller
implements Marshaller<Request<ModifyVolumeRequest>, ModifyVolumeRequest> {
    public Request<ModifyVolumeRequest> marshall(ModifyVolumeRequest modifyVolumeRequest) {
        if (modifyVolumeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyVolumeRequest, "EC2Client");
        request.addParameter("Action", "ModifyVolume");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVolumeRequest.volumeId() != null) {
            request.addParameter("VolumeId", StringUtils.fromString((String)modifyVolumeRequest.volumeId()));
        }
        if (modifyVolumeRequest.size() != null) {
            request.addParameter("Size", StringUtils.fromInteger((Integer)modifyVolumeRequest.size()));
        }
        if (modifyVolumeRequest.volumeType() != null) {
            request.addParameter("VolumeType", StringUtils.fromString((String)modifyVolumeRequest.volumeType()));
        }
        if (modifyVolumeRequest.iops() != null) {
            request.addParameter("Iops", StringUtils.fromInteger((Integer)modifyVolumeRequest.iops()));
        }
        return request;
    }
}

