/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.InstanceStatusEvent;

public class InstanceStatusEventUnmarshaller
implements Unmarshaller<InstanceStatusEvent, StaxUnmarshallerContext> {
    private static final InstanceStatusEventUnmarshaller INSTANCE = new InstanceStatusEventUnmarshaller();

    public InstanceStatusEvent unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        InstanceStatusEvent.Builder instanceStatusEvent = InstanceStatusEvent.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("code", targetDepth)) {
                    instanceStatusEvent.code(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("description", targetDepth)) {
                    instanceStatusEvent.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("notAfter", targetDepth)) {
                    instanceStatusEvent.notAfter(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("notBefore", targetDepth)) continue;
                instanceStatusEvent.notBefore(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (InstanceStatusEvent)instanceStatusEvent.build();
    }

    public static InstanceStatusEventUnmarshaller getInstance() {
        return INSTANCE;
    }
}

