/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6Address;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterface;
import software.amazon.awssdk.services.ec2.model.InstancePrivateIpAddress;
import software.amazon.awssdk.services.ec2.transform.GroupIdentifierUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.InstanceIpv6AddressUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.InstanceNetworkInterfaceAssociationUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.InstanceNetworkInterfaceAttachmentUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.InstancePrivateIpAddressUnmarshaller;

public class InstanceNetworkInterfaceUnmarshaller
implements Unmarshaller<InstanceNetworkInterface, StaxUnmarshallerContext> {
    private static final InstanceNetworkInterfaceUnmarshaller INSTANCE = new InstanceNetworkInterfaceUnmarshaller();

    public InstanceNetworkInterface unmarshall(StaxUnmarshallerContext context) throws Exception {
        InstanceNetworkInterface.Builder instanceNetworkInterface;
        block21: {
            instanceNetworkInterface = InstanceNetworkInterface.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<GroupIdentifier> groups = null;
            ArrayList<InstanceIpv6Address> ipv6Addresses = null;
            ArrayList<InstancePrivateIpAddress> privateIpAddresses = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    instanceNetworkInterface.groups(groups);
                    instanceNetworkInterface.ipv6Addresses(ipv6Addresses);
                    instanceNetworkInterface.privateIpAddresses(privateIpAddresses);
                    break block21;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("association", targetDepth)) {
                        instanceNetworkInterface.association(InstanceNetworkInterfaceAssociationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("attachment", targetDepth)) {
                        instanceNetworkInterface.attachment(InstanceNetworkInterfaceAttachmentUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("description", targetDepth)) {
                        instanceNetworkInterface.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("groupSet", targetDepth)) {
                        groups = new ArrayList<GroupIdentifier>();
                        continue;
                    }
                    if (context.testExpression("groupSet/item", targetDepth)) {
                        groups.add(GroupIdentifierUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ipv6AddressesSet", targetDepth)) {
                        ipv6Addresses = new ArrayList<InstanceIpv6Address>();
                        continue;
                    }
                    if (context.testExpression("ipv6AddressesSet/item", targetDepth)) {
                        ipv6Addresses.add(InstanceIpv6AddressUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("macAddress", targetDepth)) {
                        instanceNetworkInterface.macAddress(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("networkInterfaceId", targetDepth)) {
                        instanceNetworkInterface.networkInterfaceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ownerId", targetDepth)) {
                        instanceNetworkInterface.ownerId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("privateDnsName", targetDepth)) {
                        instanceNetworkInterface.privateDnsName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("privateIpAddress", targetDepth)) {
                        instanceNetworkInterface.privateIpAddress(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("privateIpAddressesSet", targetDepth)) {
                        privateIpAddresses = new ArrayList<InstancePrivateIpAddress>();
                        continue;
                    }
                    if (context.testExpression("privateIpAddressesSet/item", targetDepth)) {
                        privateIpAddresses.add(InstancePrivateIpAddressUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("sourceDestCheck", targetDepth)) {
                        instanceNetworkInterface.sourceDestCheck(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("status", targetDepth)) {
                        instanceNetworkInterface.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("subnetId", targetDepth)) {
                        instanceNetworkInterface.subnetId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("vpcId", targetDepth)) continue;
                    instanceNetworkInterface.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            instanceNetworkInterface.groups(groups);
            instanceNetworkInterface.ipv6Addresses(ipv6Addresses);
            instanceNetworkInterface.privateIpAddresses(privateIpAddresses);
        }
        return (InstanceNetworkInterface)instanceNetworkInterface.build();
    }

    public static InstanceNetworkInterfaceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

