/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeSpotInstanceRequestsRequestMarshaller
implements Marshaller<Request<DescribeSpotInstanceRequestsRequest>, DescribeSpotInstanceRequestsRequest> {
    public Request<DescribeSpotInstanceRequestsRequest> marshall(DescribeSpotInstanceRequestsRequest describeSpotInstanceRequestsRequest) {
        List<String> describeSpotInstanceRequestsRequestSpotInstanceRequestIdsList;
        if (describeSpotInstanceRequestsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSpotInstanceRequestsRequest, "EC2Client");
        request.addParameter("Action", "DescribeSpotInstanceRequests");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeSpotInstanceRequestsRequestFiltersList = describeSpotInstanceRequestsRequest.filters();
        if (describeSpotInstanceRequestsRequestFiltersList != null) {
            int filtersListIndex = 1;
            for (Filter describeSpotInstanceRequestsRequestFiltersListValue : describeSpotInstanceRequestsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeSpotInstanceRequestsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeSpotInstanceRequestsRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describeSpotInstanceRequestsRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if ((describeSpotInstanceRequestsRequestSpotInstanceRequestIdsList = describeSpotInstanceRequestsRequest.spotInstanceRequestIds()) != null) {
            int spotInstanceRequestIdsListIndex = 1;
            for (String describeSpotInstanceRequestsRequestSpotInstanceRequestIdsListValue : describeSpotInstanceRequestsRequestSpotInstanceRequestIdsList) {
                if (describeSpotInstanceRequestsRequestSpotInstanceRequestIdsListValue != null) {
                    request.addParameter("SpotInstanceRequestId." + spotInstanceRequestIdsListIndex, StringUtils.fromString((String)describeSpotInstanceRequestsRequestSpotInstanceRequestIdsListValue));
                }
                ++spotInstanceRequestIdsListIndex;
            }
        }
        return request;
    }
}

