/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.time.Instant;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeSpotFleetRequestHistoryRequestMarshaller
implements Marshaller<Request<DescribeSpotFleetRequestHistoryRequest>, DescribeSpotFleetRequestHistoryRequest> {
    public Request<DescribeSpotFleetRequestHistoryRequest> marshall(DescribeSpotFleetRequestHistoryRequest describeSpotFleetRequestHistoryRequest) {
        if (describeSpotFleetRequestHistoryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSpotFleetRequestHistoryRequest, "EC2Client");
        request.addParameter("Action", "DescribeSpotFleetRequestHistory");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeSpotFleetRequestHistoryRequest.eventType() != null) {
            request.addParameter("EventType", StringUtils.fromString((String)describeSpotFleetRequestHistoryRequest.eventType()));
        }
        if (describeSpotFleetRequestHistoryRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeSpotFleetRequestHistoryRequest.maxResults()));
        }
        if (describeSpotFleetRequestHistoryRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeSpotFleetRequestHistoryRequest.nextToken()));
        }
        if (describeSpotFleetRequestHistoryRequest.spotFleetRequestId() != null) {
            request.addParameter("SpotFleetRequestId", StringUtils.fromString((String)describeSpotFleetRequestHistoryRequest.spotFleetRequestId()));
        }
        if (describeSpotFleetRequestHistoryRequest.startTime() != null) {
            request.addParameter("StartTime", StringUtils.fromInstant((Instant)describeSpotFleetRequestHistoryRequest.startTime()));
        }
        return request;
    }
}

