/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeSpotFleetInstancesRequestMarshaller
implements Marshaller<Request<DescribeSpotFleetInstancesRequest>, DescribeSpotFleetInstancesRequest> {
    public Request<DescribeSpotFleetInstancesRequest> marshall(DescribeSpotFleetInstancesRequest describeSpotFleetInstancesRequest) {
        if (describeSpotFleetInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSpotFleetInstancesRequest, "EC2Client");
        request.addParameter("Action", "DescribeSpotFleetInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeSpotFleetInstancesRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeSpotFleetInstancesRequest.maxResults()));
        }
        if (describeSpotFleetInstancesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeSpotFleetInstancesRequest.nextToken()));
        }
        if (describeSpotFleetInstancesRequest.spotFleetRequestId() != null) {
            request.addParameter("SpotFleetRequestId", StringUtils.fromString((String)describeSpotFleetInstancesRequest.spotFleetRequestId()));
        }
        return request;
    }
}

