/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotAttributeRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeSnapshotAttributeRequestMarshaller
implements Marshaller<Request<DescribeSnapshotAttributeRequest>, DescribeSnapshotAttributeRequest> {
    public Request<DescribeSnapshotAttributeRequest> marshall(DescribeSnapshotAttributeRequest describeSnapshotAttributeRequest) {
        if (describeSnapshotAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSnapshotAttributeRequest, "EC2Client");
        request.addParameter("Action", "DescribeSnapshotAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeSnapshotAttributeRequest.attribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)describeSnapshotAttributeRequest.attribute()));
        }
        if (describeSnapshotAttributeRequest.snapshotId() != null) {
            request.addParameter("SnapshotId", StringUtils.fromString((String)describeSnapshotAttributeRequest.snapshotId()));
        }
        return request;
    }
}

