/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import software.amazon.awssdk.services.ec2.model.VolumeModificationState;
import software.amazon.awssdk.services.ec2.model.VolumeType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VolumeModification
implements ToCopyableBuilder<Builder, VolumeModification> {
    private final String volumeId;
    private final String modificationState;
    private final String statusMessage;
    private final Integer targetSize;
    private final Integer targetIops;
    private final String targetVolumeType;
    private final Integer originalSize;
    private final Integer originalIops;
    private final String originalVolumeType;
    private final Long progress;
    private final Instant startTime;
    private final Instant endTime;

    private VolumeModification(BuilderImpl builder) {
        this.volumeId = builder.volumeId;
        this.modificationState = builder.modificationState;
        this.statusMessage = builder.statusMessage;
        this.targetSize = builder.targetSize;
        this.targetIops = builder.targetIops;
        this.targetVolumeType = builder.targetVolumeType;
        this.originalSize = builder.originalSize;
        this.originalIops = builder.originalIops;
        this.originalVolumeType = builder.originalVolumeType;
        this.progress = builder.progress;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public String volumeId() {
        return this.volumeId;
    }

    public String modificationState() {
        return this.modificationState;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Integer targetSize() {
        return this.targetSize;
    }

    public Integer targetIops() {
        return this.targetIops;
    }

    public String targetVolumeType() {
        return this.targetVolumeType;
    }

    public Integer originalSize() {
        return this.originalSize;
    }

    public Integer originalIops() {
        return this.originalIops;
    }

    public String originalVolumeType() {
        return this.originalVolumeType;
    }

    public Long progress() {
        return this.progress;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.volumeId() == null ? 0 : this.volumeId().hashCode());
        hashCode = 31 * hashCode + (this.modificationState() == null ? 0 : this.modificationState().hashCode());
        hashCode = 31 * hashCode + (this.statusMessage() == null ? 0 : this.statusMessage().hashCode());
        hashCode = 31 * hashCode + (this.targetSize() == null ? 0 : this.targetSize().hashCode());
        hashCode = 31 * hashCode + (this.targetIops() == null ? 0 : this.targetIops().hashCode());
        hashCode = 31 * hashCode + (this.targetVolumeType() == null ? 0 : this.targetVolumeType().hashCode());
        hashCode = 31 * hashCode + (this.originalSize() == null ? 0 : this.originalSize().hashCode());
        hashCode = 31 * hashCode + (this.originalIops() == null ? 0 : this.originalIops().hashCode());
        hashCode = 31 * hashCode + (this.originalVolumeType() == null ? 0 : this.originalVolumeType().hashCode());
        hashCode = 31 * hashCode + (this.progress() == null ? 0 : this.progress().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeModification)) {
            return false;
        }
        VolumeModification other = (VolumeModification)obj;
        if (other.volumeId() == null ^ this.volumeId() == null) {
            return false;
        }
        if (other.volumeId() != null && !other.volumeId().equals(this.volumeId())) {
            return false;
        }
        if (other.modificationState() == null ^ this.modificationState() == null) {
            return false;
        }
        if (other.modificationState() != null && !other.modificationState().equals(this.modificationState())) {
            return false;
        }
        if (other.statusMessage() == null ^ this.statusMessage() == null) {
            return false;
        }
        if (other.statusMessage() != null && !other.statusMessage().equals(this.statusMessage())) {
            return false;
        }
        if (other.targetSize() == null ^ this.targetSize() == null) {
            return false;
        }
        if (other.targetSize() != null && !other.targetSize().equals(this.targetSize())) {
            return false;
        }
        if (other.targetIops() == null ^ this.targetIops() == null) {
            return false;
        }
        if (other.targetIops() != null && !other.targetIops().equals(this.targetIops())) {
            return false;
        }
        if (other.targetVolumeType() == null ^ this.targetVolumeType() == null) {
            return false;
        }
        if (other.targetVolumeType() != null && !other.targetVolumeType().equals(this.targetVolumeType())) {
            return false;
        }
        if (other.originalSize() == null ^ this.originalSize() == null) {
            return false;
        }
        if (other.originalSize() != null && !other.originalSize().equals(this.originalSize())) {
            return false;
        }
        if (other.originalIops() == null ^ this.originalIops() == null) {
            return false;
        }
        if (other.originalIops() != null && !other.originalIops().equals(this.originalIops())) {
            return false;
        }
        if (other.originalVolumeType() == null ^ this.originalVolumeType() == null) {
            return false;
        }
        if (other.originalVolumeType() != null && !other.originalVolumeType().equals(this.originalVolumeType())) {
            return false;
        }
        if (other.progress() == null ^ this.progress() == null) {
            return false;
        }
        if (other.progress() != null && !other.progress().equals(this.progress())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        return other.endTime() == null || other.endTime().equals(this.endTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.volumeId() != null) {
            sb.append("VolumeId: ").append(this.volumeId()).append(",");
        }
        if (this.modificationState() != null) {
            sb.append("ModificationState: ").append(this.modificationState()).append(",");
        }
        if (this.statusMessage() != null) {
            sb.append("StatusMessage: ").append(this.statusMessage()).append(",");
        }
        if (this.targetSize() != null) {
            sb.append("TargetSize: ").append(this.targetSize()).append(",");
        }
        if (this.targetIops() != null) {
            sb.append("TargetIops: ").append(this.targetIops()).append(",");
        }
        if (this.targetVolumeType() != null) {
            sb.append("TargetVolumeType: ").append(this.targetVolumeType()).append(",");
        }
        if (this.originalSize() != null) {
            sb.append("OriginalSize: ").append(this.originalSize()).append(",");
        }
        if (this.originalIops() != null) {
            sb.append("OriginalIops: ").append(this.originalIops()).append(",");
        }
        if (this.originalVolumeType() != null) {
            sb.append("OriginalVolumeType: ").append(this.originalVolumeType()).append(",");
        }
        if (this.progress() != null) {
            sb.append("Progress: ").append(this.progress()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String volumeId;
        private String modificationState;
        private String statusMessage;
        private Integer targetSize;
        private Integer targetIops;
        private String targetVolumeType;
        private Integer originalSize;
        private Integer originalIops;
        private String originalVolumeType;
        private Long progress;
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeModification model) {
            this.setVolumeId(model.volumeId);
            this.setModificationState(model.modificationState);
            this.setStatusMessage(model.statusMessage);
            this.setTargetSize(model.targetSize);
            this.setTargetIops(model.targetIops);
            this.setTargetVolumeType(model.targetVolumeType);
            this.setOriginalSize(model.originalSize);
            this.setOriginalIops(model.originalIops);
            this.setOriginalVolumeType(model.originalVolumeType);
            this.setProgress(model.progress);
            this.setStartTime(model.startTime);
            this.setEndTime(model.endTime);
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final String getModificationState() {
            return this.modificationState;
        }

        @Override
        public final Builder modificationState(String modificationState) {
            this.modificationState = modificationState;
            return this;
        }

        @Override
        public final Builder modificationState(VolumeModificationState modificationState) {
            this.modificationState(modificationState.toString());
            return this;
        }

        public final void setModificationState(String modificationState) {
            this.modificationState = modificationState;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Integer getTargetSize() {
            return this.targetSize;
        }

        @Override
        public final Builder targetSize(Integer targetSize) {
            this.targetSize = targetSize;
            return this;
        }

        public final void setTargetSize(Integer targetSize) {
            this.targetSize = targetSize;
        }

        public final Integer getTargetIops() {
            return this.targetIops;
        }

        @Override
        public final Builder targetIops(Integer targetIops) {
            this.targetIops = targetIops;
            return this;
        }

        public final void setTargetIops(Integer targetIops) {
            this.targetIops = targetIops;
        }

        public final String getTargetVolumeType() {
            return this.targetVolumeType;
        }

        @Override
        public final Builder targetVolumeType(String targetVolumeType) {
            this.targetVolumeType = targetVolumeType;
            return this;
        }

        @Override
        public final Builder targetVolumeType(VolumeType targetVolumeType) {
            this.targetVolumeType(targetVolumeType.toString());
            return this;
        }

        public final void setTargetVolumeType(String targetVolumeType) {
            this.targetVolumeType = targetVolumeType;
        }

        public final Integer getOriginalSize() {
            return this.originalSize;
        }

        @Override
        public final Builder originalSize(Integer originalSize) {
            this.originalSize = originalSize;
            return this;
        }

        public final void setOriginalSize(Integer originalSize) {
            this.originalSize = originalSize;
        }

        public final Integer getOriginalIops() {
            return this.originalIops;
        }

        @Override
        public final Builder originalIops(Integer originalIops) {
            this.originalIops = originalIops;
            return this;
        }

        public final void setOriginalIops(Integer originalIops) {
            this.originalIops = originalIops;
        }

        public final String getOriginalVolumeType() {
            return this.originalVolumeType;
        }

        @Override
        public final Builder originalVolumeType(String originalVolumeType) {
            this.originalVolumeType = originalVolumeType;
            return this;
        }

        @Override
        public final Builder originalVolumeType(VolumeType originalVolumeType) {
            this.originalVolumeType(originalVolumeType.toString());
            return this;
        }

        public final void setOriginalVolumeType(String originalVolumeType) {
            this.originalVolumeType = originalVolumeType;
        }

        public final Long getProgress() {
            return this.progress;
        }

        @Override
        public final Builder progress(Long progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(Long progress) {
            this.progress = progress;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public VolumeModification build() {
            return new VolumeModification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VolumeModification> {
        public Builder volumeId(String var1);

        public Builder modificationState(String var1);

        public Builder modificationState(VolumeModificationState var1);

        public Builder statusMessage(String var1);

        public Builder targetSize(Integer var1);

        public Builder targetIops(Integer var1);

        public Builder targetVolumeType(String var1);

        public Builder targetVolumeType(VolumeType var1);

        public Builder originalSize(Integer var1);

        public Builder originalIops(Integer var1);

        public Builder originalVolumeType(String var1);

        public Builder originalVolumeType(VolumeType var1);

        public Builder progress(Long var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

