/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SpotInstanceStatus
implements ToCopyableBuilder<Builder, SpotInstanceStatus> {
    private final String code;
    private final String message;
    private final Instant updateTime;

    private SpotInstanceStatus(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
        this.updateTime = builder.updateTime;
    }

    public String code() {
        return this.code;
    }

    public String message() {
        return this.message;
    }

    public Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.code() == null ? 0 : this.code().hashCode());
        hashCode = 31 * hashCode + (this.message() == null ? 0 : this.message().hashCode());
        hashCode = 31 * hashCode + (this.updateTime() == null ? 0 : this.updateTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotInstanceStatus)) {
            return false;
        }
        SpotInstanceStatus other = (SpotInstanceStatus)obj;
        if (other.code() == null ^ this.code() == null) {
            return false;
        }
        if (other.code() != null && !other.code().equals(this.code())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.updateTime() == null ^ this.updateTime() == null) {
            return false;
        }
        return other.updateTime() == null || other.updateTime().equals(this.updateTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.code() != null) {
            sb.append("Code: ").append(this.code()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (this.updateTime() != null) {
            sb.append("UpdateTime: ").append(this.updateTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String code;
        private String message;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotInstanceStatus model) {
            this.setCode(model.code);
            this.setMessage(model.message);
            this.setUpdateTime(model.updateTime);
        }

        public final String getCode() {
            return this.code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        public SpotInstanceStatus build() {
            return new SpotInstanceStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SpotInstanceStatus> {
        public Builder code(String var1);

        public Builder message(String var1);

        public Builder updateTime(Instant var1);
    }
}

