/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.services.ec2.model.UserBucket;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SnapshotDiskContainer
implements ToCopyableBuilder<Builder, SnapshotDiskContainer> {
    private final String description;
    private final String format;
    private final String url;
    private final UserBucket userBucket;

    private SnapshotDiskContainer(BuilderImpl builder) {
        this.description = builder.description;
        this.format = builder.format;
        this.url = builder.url;
        this.userBucket = builder.userBucket;
    }

    public String description() {
        return this.description;
    }

    public String format() {
        return this.format;
    }

    public String url() {
        return this.url;
    }

    public UserBucket userBucket() {
        return this.userBucket;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.format() == null ? 0 : this.format().hashCode());
        hashCode = 31 * hashCode + (this.url() == null ? 0 : this.url().hashCode());
        hashCode = 31 * hashCode + (this.userBucket() == null ? 0 : this.userBucket().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotDiskContainer)) {
            return false;
        }
        SnapshotDiskContainer other = (SnapshotDiskContainer)obj;
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.format() == null ^ this.format() == null) {
            return false;
        }
        if (other.format() != null && !other.format().equals(this.format())) {
            return false;
        }
        if (other.url() == null ^ this.url() == null) {
            return false;
        }
        if (other.url() != null && !other.url().equals(this.url())) {
            return false;
        }
        if (other.userBucket() == null ^ this.userBucket() == null) {
            return false;
        }
        return other.userBucket() == null || other.userBucket().equals(this.userBucket());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.format() != null) {
            sb.append("Format: ").append(this.format()).append(",");
        }
        if (this.url() != null) {
            sb.append("Url: ").append(this.url()).append(",");
        }
        if (this.userBucket() != null) {
            sb.append("UserBucket: ").append(this.userBucket()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String description;
        private String format;
        private String url;
        private UserBucket userBucket;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotDiskContainer model) {
            this.setDescription(model.description);
            this.setFormat(model.format);
            this.setUrl(model.url);
            this.setUserBucket(model.userBucket);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final UserBucket getUserBucket() {
            return this.userBucket;
        }

        @Override
        public final Builder userBucket(UserBucket userBucket) {
            this.userBucket = userBucket;
            return this;
        }

        public final void setUserBucket(UserBucket userBucket) {
            this.userBucket = userBucket;
        }

        public SnapshotDiskContainer build() {
            return new SnapshotDiskContainer(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SnapshotDiskContainer> {
        public Builder description(String var1);

        public Builder format(String var1);

        public Builder url(String var1);

        public Builder userBucket(UserBucket var1);
    }
}

