/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.SnapshotState;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Snapshot
implements ToCopyableBuilder<Builder, Snapshot> {
    private final String dataEncryptionKeyId;
    private final String description;
    private final Boolean encrypted;
    private final String kmsKeyId;
    private final String ownerId;
    private final String progress;
    private final String snapshotId;
    private final Instant startTime;
    private final String state;
    private final String stateMessage;
    private final String volumeId;
    private final Integer volumeSize;
    private final String ownerAlias;
    private final List<Tag> tags;

    private Snapshot(BuilderImpl builder) {
        this.dataEncryptionKeyId = builder.dataEncryptionKeyId;
        this.description = builder.description;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.ownerId = builder.ownerId;
        this.progress = builder.progress;
        this.snapshotId = builder.snapshotId;
        this.startTime = builder.startTime;
        this.state = builder.state;
        this.stateMessage = builder.stateMessage;
        this.volumeId = builder.volumeId;
        this.volumeSize = builder.volumeSize;
        this.ownerAlias = builder.ownerAlias;
        this.tags = builder.tags;
    }

    public String dataEncryptionKeyId() {
        return this.dataEncryptionKeyId;
    }

    public String description() {
        return this.description;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String progress() {
        return this.progress;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public String state() {
        return this.state;
    }

    public String stateMessage() {
        return this.stateMessage;
    }

    public String volumeId() {
        return this.volumeId;
    }

    public Integer volumeSize() {
        return this.volumeSize;
    }

    public String ownerAlias() {
        return this.ownerAlias;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dataEncryptionKeyId() == null ? 0 : this.dataEncryptionKeyId().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.encrypted() == null ? 0 : this.encrypted().hashCode());
        hashCode = 31 * hashCode + (this.kmsKeyId() == null ? 0 : this.kmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.ownerId() == null ? 0 : this.ownerId().hashCode());
        hashCode = 31 * hashCode + (this.progress() == null ? 0 : this.progress().hashCode());
        hashCode = 31 * hashCode + (this.snapshotId() == null ? 0 : this.snapshotId().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.stateMessage() == null ? 0 : this.stateMessage().hashCode());
        hashCode = 31 * hashCode + (this.volumeId() == null ? 0 : this.volumeId().hashCode());
        hashCode = 31 * hashCode + (this.volumeSize() == null ? 0 : this.volumeSize().hashCode());
        hashCode = 31 * hashCode + (this.ownerAlias() == null ? 0 : this.ownerAlias().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot)obj;
        if (other.dataEncryptionKeyId() == null ^ this.dataEncryptionKeyId() == null) {
            return false;
        }
        if (other.dataEncryptionKeyId() != null && !other.dataEncryptionKeyId().equals(this.dataEncryptionKeyId())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.encrypted() == null ^ this.encrypted() == null) {
            return false;
        }
        if (other.encrypted() != null && !other.encrypted().equals(this.encrypted())) {
            return false;
        }
        if (other.kmsKeyId() == null ^ this.kmsKeyId() == null) {
            return false;
        }
        if (other.kmsKeyId() != null && !other.kmsKeyId().equals(this.kmsKeyId())) {
            return false;
        }
        if (other.ownerId() == null ^ this.ownerId() == null) {
            return false;
        }
        if (other.ownerId() != null && !other.ownerId().equals(this.ownerId())) {
            return false;
        }
        if (other.progress() == null ^ this.progress() == null) {
            return false;
        }
        if (other.progress() != null && !other.progress().equals(this.progress())) {
            return false;
        }
        if (other.snapshotId() == null ^ this.snapshotId() == null) {
            return false;
        }
        if (other.snapshotId() != null && !other.snapshotId().equals(this.snapshotId())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.stateMessage() == null ^ this.stateMessage() == null) {
            return false;
        }
        if (other.stateMessage() != null && !other.stateMessage().equals(this.stateMessage())) {
            return false;
        }
        if (other.volumeId() == null ^ this.volumeId() == null) {
            return false;
        }
        if (other.volumeId() != null && !other.volumeId().equals(this.volumeId())) {
            return false;
        }
        if (other.volumeSize() == null ^ this.volumeSize() == null) {
            return false;
        }
        if (other.volumeSize() != null && !other.volumeSize().equals(this.volumeSize())) {
            return false;
        }
        if (other.ownerAlias() == null ^ this.ownerAlias() == null) {
            return false;
        }
        if (other.ownerAlias() != null && !other.ownerAlias().equals(this.ownerAlias())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dataEncryptionKeyId() != null) {
            sb.append("DataEncryptionKeyId: ").append(this.dataEncryptionKeyId()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.encrypted() != null) {
            sb.append("Encrypted: ").append(this.encrypted()).append(",");
        }
        if (this.kmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.kmsKeyId()).append(",");
        }
        if (this.ownerId() != null) {
            sb.append("OwnerId: ").append(this.ownerId()).append(",");
        }
        if (this.progress() != null) {
            sb.append("Progress: ").append(this.progress()).append(",");
        }
        if (this.snapshotId() != null) {
            sb.append("SnapshotId: ").append(this.snapshotId()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.stateMessage() != null) {
            sb.append("StateMessage: ").append(this.stateMessage()).append(",");
        }
        if (this.volumeId() != null) {
            sb.append("VolumeId: ").append(this.volumeId()).append(",");
        }
        if (this.volumeSize() != null) {
            sb.append("VolumeSize: ").append(this.volumeSize()).append(",");
        }
        if (this.ownerAlias() != null) {
            sb.append("OwnerAlias: ").append(this.ownerAlias()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String dataEncryptionKeyId;
        private String description;
        private Boolean encrypted;
        private String kmsKeyId;
        private String ownerId;
        private String progress;
        private String snapshotId;
        private Instant startTime;
        private String state;
        private String stateMessage;
        private String volumeId;
        private Integer volumeSize;
        private String ownerAlias;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(Snapshot model) {
            this.setDataEncryptionKeyId(model.dataEncryptionKeyId);
            this.setDescription(model.description);
            this.setEncrypted(model.encrypted);
            this.setKmsKeyId(model.kmsKeyId);
            this.setOwnerId(model.ownerId);
            this.setProgress(model.progress);
            this.setSnapshotId(model.snapshotId);
            this.setStartTime(model.startTime);
            this.setState(model.state);
            this.setStateMessage(model.stateMessage);
            this.setVolumeId(model.volumeId);
            this.setVolumeSize(model.volumeSize);
            this.setOwnerAlias(model.ownerAlias);
            this.setTags(model.tags);
        }

        public final String getDataEncryptionKeyId() {
            return this.dataEncryptionKeyId;
        }

        @Override
        public final Builder dataEncryptionKeyId(String dataEncryptionKeyId) {
            this.dataEncryptionKeyId = dataEncryptionKeyId;
            return this;
        }

        public final void setDataEncryptionKeyId(String dataEncryptionKeyId) {
            this.dataEncryptionKeyId = dataEncryptionKeyId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getProgress() {
            return this.progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SnapshotState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateMessage() {
            return this.stateMessage;
        }

        @Override
        public final Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        public final void setStateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final Integer getVolumeSize() {
            return this.volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        public final String getOwnerAlias() {
            return this.ownerAlias;
        }

        @Override
        public final Builder ownerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
            return this;
        }

        public final void setOwnerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        public Snapshot build() {
            return new Snapshot(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Snapshot> {
        public Builder dataEncryptionKeyId(String var1);

        public Builder description(String var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder ownerId(String var1);

        public Builder progress(String var1);

        public Builder snapshotId(String var1);

        public Builder startTime(Instant var1);

        public Builder state(String var1);

        public Builder state(SnapshotState var1);

        public Builder stateMessage(String var1);

        public Builder volumeId(String var1);

        public Builder volumeSize(Integer var1);

        public Builder ownerAlias(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

