/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.services.ec2.model.InstanceState;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceStateChange
implements ToCopyableBuilder<Builder, InstanceStateChange> {
    private final InstanceState currentState;
    private final String instanceId;
    private final InstanceState previousState;

    private InstanceStateChange(BuilderImpl builder) {
        this.currentState = builder.currentState;
        this.instanceId = builder.instanceId;
        this.previousState = builder.previousState;
    }

    public InstanceState currentState() {
        return this.currentState;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public InstanceState previousState() {
        return this.previousState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.currentState() == null ? 0 : this.currentState().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.previousState() == null ? 0 : this.previousState().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStateChange)) {
            return false;
        }
        InstanceStateChange other = (InstanceStateChange)obj;
        if (other.currentState() == null ^ this.currentState() == null) {
            return false;
        }
        if (other.currentState() != null && !other.currentState().equals(this.currentState())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.previousState() == null ^ this.previousState() == null) {
            return false;
        }
        return other.previousState() == null || other.previousState().equals(this.previousState());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.currentState() != null) {
            sb.append("CurrentState: ").append(this.currentState()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.previousState() != null) {
            sb.append("PreviousState: ").append(this.previousState()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private InstanceState currentState;
        private String instanceId;
        private InstanceState previousState;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStateChange model) {
            this.setCurrentState(model.currentState);
            this.setInstanceId(model.instanceId);
            this.setPreviousState(model.previousState);
        }

        public final InstanceState getCurrentState() {
            return this.currentState;
        }

        @Override
        public final Builder currentState(InstanceState currentState) {
            this.currentState = currentState;
            return this;
        }

        public final void setCurrentState(InstanceState currentState) {
            this.currentState = currentState;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final InstanceState getPreviousState() {
            return this.previousState;
        }

        @Override
        public final Builder previousState(InstanceState previousState) {
            this.previousState = previousState;
            return this;
        }

        public final void setPreviousState(InstanceState previousState) {
            this.previousState = previousState;
        }

        public InstanceStateChange build() {
            return new InstanceStateChange(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceStateChange> {
        public Builder currentState(InstanceState var1);

        public Builder instanceId(String var1);

        public Builder previousState(InstanceState var1);
    }
}

