/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IdFormat
implements ToCopyableBuilder<Builder, IdFormat> {
    private final Instant deadline;
    private final String resource;
    private final Boolean useLongIds;

    private IdFormat(BuilderImpl builder) {
        this.deadline = builder.deadline;
        this.resource = builder.resource;
        this.useLongIds = builder.useLongIds;
    }

    public Instant deadline() {
        return this.deadline;
    }

    public String resource() {
        return this.resource;
    }

    public Boolean useLongIds() {
        return this.useLongIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deadline() == null ? 0 : this.deadline().hashCode());
        hashCode = 31 * hashCode + (this.resource() == null ? 0 : this.resource().hashCode());
        hashCode = 31 * hashCode + (this.useLongIds() == null ? 0 : this.useLongIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdFormat)) {
            return false;
        }
        IdFormat other = (IdFormat)obj;
        if (other.deadline() == null ^ this.deadline() == null) {
            return false;
        }
        if (other.deadline() != null && !other.deadline().equals(this.deadline())) {
            return false;
        }
        if (other.resource() == null ^ this.resource() == null) {
            return false;
        }
        if (other.resource() != null && !other.resource().equals(this.resource())) {
            return false;
        }
        if (other.useLongIds() == null ^ this.useLongIds() == null) {
            return false;
        }
        return other.useLongIds() == null || other.useLongIds().equals(this.useLongIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deadline() != null) {
            sb.append("Deadline: ").append(this.deadline()).append(",");
        }
        if (this.resource() != null) {
            sb.append("Resource: ").append(this.resource()).append(",");
        }
        if (this.useLongIds() != null) {
            sb.append("UseLongIds: ").append(this.useLongIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Instant deadline;
        private String resource;
        private Boolean useLongIds;

        private BuilderImpl() {
        }

        private BuilderImpl(IdFormat model) {
            this.setDeadline(model.deadline);
            this.setResource(model.resource);
            this.setUseLongIds(model.useLongIds);
        }

        public final Instant getDeadline() {
            return this.deadline;
        }

        @Override
        public final Builder deadline(Instant deadline) {
            this.deadline = deadline;
            return this;
        }

        public final void setDeadline(Instant deadline) {
            this.deadline = deadline;
        }

        public final String getResource() {
            return this.resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        public final Boolean getUseLongIds() {
            return this.useLongIds;
        }

        @Override
        public final Builder useLongIds(Boolean useLongIds) {
            this.useLongIds = useLongIds;
            return this;
        }

        public final void setUseLongIds(Boolean useLongIds) {
            this.useLongIds = useLongIds;
        }

        public IdFormat build() {
            return new IdFormat(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IdFormat> {
        public Builder deadline(Instant var1);

        public Builder resource(String var1);

        public Builder useLongIds(Boolean var1);
    }
}

