/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.GatewayType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateCustomerGatewayRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateCustomerGatewayRequest> {
    private final Integer bgpAsn;
    private final String publicIp;
    private final String type;

    private CreateCustomerGatewayRequest(BuilderImpl builder) {
        this.bgpAsn = builder.bgpAsn;
        this.publicIp = builder.publicIp;
        this.type = builder.type;
    }

    public Integer bgpAsn() {
        return this.bgpAsn;
    }

    public String publicIp() {
        return this.publicIp;
    }

    public String type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bgpAsn() == null ? 0 : this.bgpAsn().hashCode());
        hashCode = 31 * hashCode + (this.publicIp() == null ? 0 : this.publicIp().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomerGatewayRequest)) {
            return false;
        }
        CreateCustomerGatewayRequest other = (CreateCustomerGatewayRequest)((Object)obj);
        if (other.bgpAsn() == null ^ this.bgpAsn() == null) {
            return false;
        }
        if (other.bgpAsn() != null && !other.bgpAsn().equals(this.bgpAsn())) {
            return false;
        }
        if (other.publicIp() == null ^ this.publicIp() == null) {
            return false;
        }
        if (other.publicIp() != null && !other.publicIp().equals(this.publicIp())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        return other.type() == null || other.type().equals(this.type());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bgpAsn() != null) {
            sb.append("BgpAsn: ").append(this.bgpAsn()).append(",");
        }
        if (this.publicIp() != null) {
            sb.append("PublicIp: ").append(this.publicIp()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer bgpAsn;
        private String publicIp;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomerGatewayRequest model) {
            this.setBgpAsn(model.bgpAsn);
            this.setPublicIp(model.publicIp);
            this.setType(model.type);
        }

        public final Integer getBgpAsn() {
            return this.bgpAsn;
        }

        @Override
        public final Builder bgpAsn(Integer bgpAsn) {
            this.bgpAsn = bgpAsn;
            return this;
        }

        public final void setBgpAsn(Integer bgpAsn) {
            this.bgpAsn = bgpAsn;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GatewayType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public CreateCustomerGatewayRequest build() {
            return new CreateCustomerGatewayRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateCustomerGatewayRequest> {
        public Builder bgpAsn(Integer var1);

        public Builder publicIp(String var1);

        public Builder type(String var1);

        public Builder type(GatewayType var1);
    }
}

