/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsErrorItem;
import software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsErrorSetCopier;
import software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsSuccessItem;
import software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsSuccessSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CancelSpotFleetRequestsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, CancelSpotFleetRequestsResponse> {
    private final List<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests;
    private final List<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests;

    private CancelSpotFleetRequestsResponse(BuilderImpl builder) {
        this.successfulFleetRequests = builder.successfulFleetRequests;
        this.unsuccessfulFleetRequests = builder.unsuccessfulFleetRequests;
    }

    public List<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests() {
        return this.successfulFleetRequests;
    }

    public List<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests() {
        return this.unsuccessfulFleetRequests;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.successfulFleetRequests() == null ? 0 : this.successfulFleetRequests().hashCode());
        hashCode = 31 * hashCode + (this.unsuccessfulFleetRequests() == null ? 0 : this.unsuccessfulFleetRequests().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotFleetRequestsResponse)) {
            return false;
        }
        CancelSpotFleetRequestsResponse other = (CancelSpotFleetRequestsResponse)((Object)obj);
        if (other.successfulFleetRequests() == null ^ this.successfulFleetRequests() == null) {
            return false;
        }
        if (other.successfulFleetRequests() != null && !other.successfulFleetRequests().equals(this.successfulFleetRequests())) {
            return false;
        }
        if (other.unsuccessfulFleetRequests() == null ^ this.unsuccessfulFleetRequests() == null) {
            return false;
        }
        return other.unsuccessfulFleetRequests() == null || other.unsuccessfulFleetRequests().equals(this.unsuccessfulFleetRequests());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.successfulFleetRequests() != null) {
            sb.append("SuccessfulFleetRequests: ").append(this.successfulFleetRequests()).append(",");
        }
        if (this.unsuccessfulFleetRequests() != null) {
            sb.append("UnsuccessfulFleetRequests: ").append(this.unsuccessfulFleetRequests()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests;
        private List<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSpotFleetRequestsResponse model) {
            this.setSuccessfulFleetRequests(model.successfulFleetRequests);
            this.setUnsuccessfulFleetRequests(model.unsuccessfulFleetRequests);
        }

        public final Collection<CancelSpotFleetRequestsSuccessItem> getSuccessfulFleetRequests() {
            return this.successfulFleetRequests;
        }

        @Override
        public final Builder successfulFleetRequests(Collection<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests) {
            this.successfulFleetRequests = CancelSpotFleetRequestsSuccessSetCopier.copy(successfulFleetRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulFleetRequests(CancelSpotFleetRequestsSuccessItem ... successfulFleetRequests) {
            this.successfulFleetRequests(Arrays.asList(successfulFleetRequests));
            return this;
        }

        public final void setSuccessfulFleetRequests(Collection<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests) {
            this.successfulFleetRequests = CancelSpotFleetRequestsSuccessSetCopier.copy(successfulFleetRequests);
        }

        public final Collection<CancelSpotFleetRequestsErrorItem> getUnsuccessfulFleetRequests() {
            return this.unsuccessfulFleetRequests;
        }

        @Override
        public final Builder unsuccessfulFleetRequests(Collection<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests) {
            this.unsuccessfulFleetRequests = CancelSpotFleetRequestsErrorSetCopier.copy(unsuccessfulFleetRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulFleetRequests(CancelSpotFleetRequestsErrorItem ... unsuccessfulFleetRequests) {
            this.unsuccessfulFleetRequests(Arrays.asList(unsuccessfulFleetRequests));
            return this;
        }

        public final void setUnsuccessfulFleetRequests(Collection<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests) {
            this.unsuccessfulFleetRequests = CancelSpotFleetRequestsErrorSetCopier.copy(unsuccessfulFleetRequests);
        }

        public CancelSpotFleetRequestsResponse build() {
            return new CancelSpotFleetRequestsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CancelSpotFleetRequestsResponse> {
        public Builder successfulFleetRequests(Collection<CancelSpotFleetRequestsSuccessItem> var1);

        public Builder successfulFleetRequests(CancelSpotFleetRequestsSuccessItem ... var1);

        public Builder unsuccessfulFleetRequests(Collection<CancelSpotFleetRequestsErrorItem> var1);

        public Builder unsuccessfulFleetRequests(CancelSpotFleetRequestsErrorItem ... var1);
    }
}

