/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssociateAddressRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AssociateAddressRequest> {
    private final String allocationId;
    private final String instanceId;
    private final String publicIp;
    private final Boolean allowReassociation;
    private final String networkInterfaceId;
    private final String privateIpAddress;

    private AssociateAddressRequest(BuilderImpl builder) {
        this.allocationId = builder.allocationId;
        this.instanceId = builder.instanceId;
        this.publicIp = builder.publicIp;
        this.allowReassociation = builder.allowReassociation;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddress = builder.privateIpAddress;
    }

    public String allocationId() {
        return this.allocationId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String publicIp() {
        return this.publicIp;
    }

    public Boolean allowReassociation() {
        return this.allowReassociation;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.allocationId() == null ? 0 : this.allocationId().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.publicIp() == null ? 0 : this.publicIp().hashCode());
        hashCode = 31 * hashCode + (this.allowReassociation() == null ? 0 : this.allowReassociation().hashCode());
        hashCode = 31 * hashCode + (this.networkInterfaceId() == null ? 0 : this.networkInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.privateIpAddress() == null ? 0 : this.privateIpAddress().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateAddressRequest)) {
            return false;
        }
        AssociateAddressRequest other = (AssociateAddressRequest)((Object)obj);
        if (other.allocationId() == null ^ this.allocationId() == null) {
            return false;
        }
        if (other.allocationId() != null && !other.allocationId().equals(this.allocationId())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.publicIp() == null ^ this.publicIp() == null) {
            return false;
        }
        if (other.publicIp() != null && !other.publicIp().equals(this.publicIp())) {
            return false;
        }
        if (other.allowReassociation() == null ^ this.allowReassociation() == null) {
            return false;
        }
        if (other.allowReassociation() != null && !other.allowReassociation().equals(this.allowReassociation())) {
            return false;
        }
        if (other.networkInterfaceId() == null ^ this.networkInterfaceId() == null) {
            return false;
        }
        if (other.networkInterfaceId() != null && !other.networkInterfaceId().equals(this.networkInterfaceId())) {
            return false;
        }
        if (other.privateIpAddress() == null ^ this.privateIpAddress() == null) {
            return false;
        }
        return other.privateIpAddress() == null || other.privateIpAddress().equals(this.privateIpAddress());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allocationId() != null) {
            sb.append("AllocationId: ").append(this.allocationId()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.publicIp() != null) {
            sb.append("PublicIp: ").append(this.publicIp()).append(",");
        }
        if (this.allowReassociation() != null) {
            sb.append("AllowReassociation: ").append(this.allowReassociation()).append(",");
        }
        if (this.networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(this.networkInterfaceId()).append(",");
        }
        if (this.privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(this.privateIpAddress()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String allocationId;
        private String instanceId;
        private String publicIp;
        private Boolean allowReassociation;
        private String networkInterfaceId;
        private String privateIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateAddressRequest model) {
            this.setAllocationId(model.allocationId);
            this.setInstanceId(model.instanceId);
            this.setPublicIp(model.publicIp);
            this.setAllowReassociation(model.allowReassociation);
            this.setNetworkInterfaceId(model.networkInterfaceId);
            this.setPrivateIpAddress(model.privateIpAddress);
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final Boolean getAllowReassociation() {
            return this.allowReassociation;
        }

        @Override
        public final Builder allowReassociation(Boolean allowReassociation) {
            this.allowReassociation = allowReassociation;
            return this;
        }

        public final void setAllowReassociation(Boolean allowReassociation) {
            this.allowReassociation = allowReassociation;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public AssociateAddressRequest build() {
            return new AssociateAddressRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssociateAddressRequest> {
        public Builder allocationId(String var1);

        public Builder instanceId(String var1);

        public Builder publicIp(String var1);

        public Builder allowReassociation(Boolean var1);

        public Builder networkInterfaceId(String var1);

        public Builder privateIpAddress(String var1);
    }
}

