/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.PropagatingVgw;
import software.amazon.awssdk.services.ec2.model.Route;
import software.amazon.awssdk.services.ec2.model.RouteTable;
import software.amazon.awssdk.services.ec2.model.RouteTableAssociation;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.transform.PropagatingVgwUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.RouteTableAssociationUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.RouteUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;

public class RouteTableUnmarshaller
implements Unmarshaller<RouteTable, StaxUnmarshallerContext> {
    private static RouteTableUnmarshaller INSTANCE;

    public RouteTable unmarshall(StaxUnmarshallerContext context) throws Exception {
        RouteTable.Builder routeTable;
        block13: {
            routeTable = RouteTable.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<RouteTableAssociation> associations = null;
            ArrayList<PropagatingVgw> propagatingVgws = null;
            ArrayList<Route> routes = null;
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    routeTable.associations(associations);
                    routeTable.propagatingVgws(propagatingVgws);
                    routeTable.routes(routes);
                    routeTable.tags(tags);
                    break block13;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("associationSet", targetDepth)) {
                        associations = new ArrayList<RouteTableAssociation>();
                        continue;
                    }
                    if (context.testExpression("associationSet/item", targetDepth)) {
                        associations.add(RouteTableAssociationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("propagatingVgwSet", targetDepth)) {
                        propagatingVgws = new ArrayList<PropagatingVgw>();
                        continue;
                    }
                    if (context.testExpression("propagatingVgwSet/item", targetDepth)) {
                        propagatingVgws.add(PropagatingVgwUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("routeTableId", targetDepth)) {
                        routeTable.routeTableId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("routeSet", targetDepth)) {
                        routes = new ArrayList<Route>();
                        continue;
                    }
                    if (context.testExpression("routeSet/item", targetDepth)) {
                        routes.add(RouteUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("tagSet", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (context.testExpression("tagSet/item", targetDepth)) {
                        tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("vpcId", targetDepth)) continue;
                    routeTable.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            routeTable.associations(associations);
            routeTable.propagatingVgws(propagatingVgws);
            routeTable.routes(routes);
            routeTable.tags(tags);
        }
        return (RouteTable)routeTable.build();
    }

    public static RouteTableUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RouteTableUnmarshaller();
        }
        return INSTANCE;
    }
}

