/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.MoveAddressToVpcRequest;
import software.amazon.awssdk.util.StringUtils;

public class MoveAddressToVpcRequestMarshaller
implements Marshaller<Request<MoveAddressToVpcRequest>, MoveAddressToVpcRequest> {
    public Request<MoveAddressToVpcRequest> marshall(MoveAddressToVpcRequest moveAddressToVpcRequest) {
        if (moveAddressToVpcRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)moveAddressToVpcRequest, "EC2Client");
        request.addParameter("Action", "MoveAddressToVpc");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (moveAddressToVpcRequest.publicIp() != null) {
            request.addParameter("PublicIp", StringUtils.fromString((String)moveAddressToVpcRequest.publicIp()));
        }
        return request;
    }
}

