/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.ModifySubnetAttributeRequest;
import software.amazon.awssdk.util.StringUtils;

public class ModifySubnetAttributeRequestMarshaller
implements Marshaller<Request<ModifySubnetAttributeRequest>, ModifySubnetAttributeRequest> {
    public Request<ModifySubnetAttributeRequest> marshall(ModifySubnetAttributeRequest modifySubnetAttributeRequest) {
        if (modifySubnetAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifySubnetAttributeRequest, "EC2Client");
        request.addParameter("Action", "ModifySubnetAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifySubnetAttributeRequest.assignIpv6AddressOnCreation() != null) {
            request.addParameter("AssignIpv6AddressOnCreation.Value", StringUtils.fromBoolean((Boolean)modifySubnetAttributeRequest.assignIpv6AddressOnCreation()));
        }
        if (modifySubnetAttributeRequest.mapPublicIpOnLaunch() != null) {
            request.addParameter("MapPublicIpOnLaunch.Value", StringUtils.fromBoolean((Boolean)modifySubnetAttributeRequest.mapPublicIpOnLaunch()));
        }
        if (modifySubnetAttributeRequest.subnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString((String)modifySubnetAttributeRequest.subnetId()));
        }
        return request;
    }
}

