/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.ModifyIdentityIdFormatRequest;
import software.amazon.awssdk.util.StringUtils;

public class ModifyIdentityIdFormatRequestMarshaller
implements Marshaller<Request<ModifyIdentityIdFormatRequest>, ModifyIdentityIdFormatRequest> {
    public Request<ModifyIdentityIdFormatRequest> marshall(ModifyIdentityIdFormatRequest modifyIdentityIdFormatRequest) {
        if (modifyIdentityIdFormatRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyIdentityIdFormatRequest, "EC2Client");
        request.addParameter("Action", "ModifyIdentityIdFormat");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyIdentityIdFormatRequest.principalArn() != null) {
            request.addParameter("PrincipalArn", StringUtils.fromString((String)modifyIdentityIdFormatRequest.principalArn()));
        }
        if (modifyIdentityIdFormatRequest.resource() != null) {
            request.addParameter("Resource", StringUtils.fromString((String)modifyIdentityIdFormatRequest.resource()));
        }
        if (modifyIdentityIdFormatRequest.useLongIds() != null) {
            request.addParameter("UseLongIds", StringUtils.fromBoolean((Boolean)modifyIdentityIdFormatRequest.useLongIds()));
        }
        return request;
    }
}

