/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DiskImageDetail;
import software.amazon.awssdk.services.ec2.model.ImportVolumeRequest;
import software.amazon.awssdk.services.ec2.model.VolumeDetail;
import software.amazon.awssdk.util.StringUtils;

public class ImportVolumeRequestMarshaller
implements Marshaller<Request<ImportVolumeRequest>, ImportVolumeRequest> {
    public Request<ImportVolumeRequest> marshall(ImportVolumeRequest importVolumeRequest) {
        VolumeDetail volume;
        DiskImageDetail image;
        if (importVolumeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)importVolumeRequest, "EC2Client");
        request.addParameter("Action", "ImportVolume");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (importVolumeRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)importVolumeRequest.availabilityZone()));
        }
        if (importVolumeRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)importVolumeRequest.description()));
        }
        if ((image = importVolumeRequest.image()) != null) {
            if (image.bytes() != null) {
                request.addParameter("Image.Bytes", StringUtils.fromLong((Long)image.bytes()));
            }
            if (image.format() != null) {
                request.addParameter("Image.Format", StringUtils.fromString((String)image.format()));
            }
            if (image.importManifestUrl() != null) {
                request.addParameter("Image.ImportManifestUrl", StringUtils.fromString((String)image.importManifestUrl()));
            }
        }
        if ((volume = importVolumeRequest.volume()) != null && volume.size() != null) {
            request.addParameter("Volume.Size", StringUtils.fromLong((Long)volume.size()));
        }
        return request;
    }
}

