/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.net.URI;
import java.net.URISyntaxException;
import software.amazon.awssdk.AmazonClientException;
import software.amazon.awssdk.Protocol;
import software.amazon.awssdk.RequestConfig;
import software.amazon.awssdk.auth.Aws4Signer;
import software.amazon.awssdk.auth.AwsCredentials;
import software.amazon.awssdk.handlers.AwsHandlerKeys;
import software.amazon.awssdk.handlers.RequestHandler;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpFullRequestAdapter;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ec2.EC2Client;
import software.amazon.awssdk.services.ec2.model.CopySnapshotRequest;
import software.amazon.awssdk.services.ec2.transform.CopySnapshotRequestMarshaller;
import software.amazon.awssdk.util.AwsHostNameUtils;
import software.amazon.awssdk.util.SdkHttpUtils;

public class GeneratePreSignUrlRequestHandler
extends RequestHandler {
    public SdkHttpFullRequest beforeRequest(SdkHttpFullRequest request) {
        Object originalRequest = ((RequestConfig)request.handlerContext(AwsHandlerKeys.REQUEST_CONFIG)).getOriginalRequest();
        if (originalRequest instanceof CopySnapshotRequest) {
            CopySnapshotRequest originalCopySnapshotRequest = (CopySnapshotRequest)((Object)originalRequest);
            if (originalCopySnapshotRequest.presignedUrl() != null) {
                return request;
            }
            String serviceName = "ec2";
            String sourceRegion = originalCopySnapshotRequest.sourceRegion();
            String sourceSnapshotId = originalCopySnapshotRequest.sourceSnapshotId();
            URI endPointDestination = request.getEndpoint();
            String destinationRegion = originalCopySnapshotRequest.destinationRegion() != null ? originalCopySnapshotRequest.destinationRegion() : AwsHostNameUtils.parseRegionName((String)endPointDestination.getHost(), (String)serviceName);
            URI endPointSource = this.createEndpoint(sourceRegion, serviceName);
            SdkHttpFullRequest requestForPresigning = (SdkHttpFullRequest)((SdkHttpFullRequest.Builder)this.generateRequestForPresigning(sourceSnapshotId, sourceRegion, destinationRegion).toBuilder()).endpoint(endPointSource).httpMethod(SdkHttpMethod.GET).build();
            Aws4Signer signer = new Aws4Signer();
            signer.setServiceName(serviceName);
            SdkHttpFullRequest presignedRequest = signer.presignRequest(requestForPresigning, (AwsCredentials)request.handlerContext(AwsHandlerKeys.AWS_CREDENTIALS), null);
            return (SdkHttpFullRequest)((SdkHttpFullRequest.Builder)request.toBuilder()).queryParameter("DestinationRegion", destinationRegion).queryParameter("PresignedUrl", this.generateUrl(presignedRequest)).build();
        }
        return request;
    }

    private SdkHttpFullRequest generateRequestForPresigning(String sourceSnapshotId, String sourceRegion, String destinationRegion) {
        CopySnapshotRequest copySnapshotRequest = (CopySnapshotRequest)((Object)CopySnapshotRequest.builder().sourceSnapshotId(sourceSnapshotId).sourceRegion(sourceRegion).destinationRegion(destinationRegion).build());
        return SdkHttpFullRequestAdapter.toHttpFullRequest(new CopySnapshotRequestMarshaller().marshall(copySnapshotRequest));
    }

    private String generateUrl(SdkHttpFullRequest request) {
        URI endpoint = request.getEndpoint();
        String uri = SdkHttpUtils.appendUri((String)endpoint.toString(), (String)request.getResourcePath(), (boolean)true);
        String encodedParams = SdkHttpUtils.encodeParameters((SdkHttpRequest)request);
        if (encodedParams != null) {
            uri = uri + "?" + encodedParams;
        }
        return uri;
    }

    private URI createEndpoint(String regionName, String serviceName) {
        Region region = Region.of((String)regionName);
        if (region == null) {
            throw new AmazonClientException("{" + serviceName + ", " + regionName + "} was not found in region metadata. Update to latest version of SDK and try again.");
        }
        return EC2Client.serviceMetadata().endpointFor(region);
    }

    private URI toUri(String endpoint) throws IllegalArgumentException {
        if (!endpoint.contains("://")) {
            endpoint = Protocol.HTTPS + "://" + endpoint;
        }
        try {
            return new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

