/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.EbsBlockDevice;

public class EbsBlockDeviceUnmarshaller
implements Unmarshaller<EbsBlockDevice, StaxUnmarshallerContext> {
    private static EbsBlockDeviceUnmarshaller INSTANCE;

    public EbsBlockDevice unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        EbsBlockDevice.Builder ebsBlockDevice = EbsBlockDevice.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("encrypted", targetDepth)) {
                    ebsBlockDevice.encrypted(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("deleteOnTermination", targetDepth)) {
                    ebsBlockDevice.deleteOnTermination(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("iops", targetDepth)) {
                    ebsBlockDevice.iops(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("snapshotId", targetDepth)) {
                    ebsBlockDevice.snapshotId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("volumeSize", targetDepth)) {
                    ebsBlockDevice.volumeSize(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("volumeType", targetDepth)) continue;
                ebsBlockDevice.volumeType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (EbsBlockDevice)ebsBlockDevice.build();
    }

    public static EbsBlockDeviceUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EbsBlockDeviceUnmarshaller();
        }
        return INSTANCE;
    }
}

