/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeIamInstanceProfileAssociationsRequestMarshaller
implements Marshaller<Request<DescribeIamInstanceProfileAssociationsRequest>, DescribeIamInstanceProfileAssociationsRequest> {
    public Request<DescribeIamInstanceProfileAssociationsRequest> marshall(DescribeIamInstanceProfileAssociationsRequest describeIamInstanceProfileAssociationsRequest) {
        List<Filter> describeIamInstanceProfileAssociationsRequestFiltersList;
        if (describeIamInstanceProfileAssociationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeIamInstanceProfileAssociationsRequest, "EC2Client");
        request.addParameter("Action", "DescribeIamInstanceProfileAssociations");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeIamInstanceProfileAssociationsRequestAssociationIdsList = describeIamInstanceProfileAssociationsRequest.associationIds();
        if (describeIamInstanceProfileAssociationsRequestAssociationIdsList != null) {
            int associationIdsListIndex = 1;
            for (String describeIamInstanceProfileAssociationsRequestAssociationIdsListValue : describeIamInstanceProfileAssociationsRequestAssociationIdsList) {
                if (describeIamInstanceProfileAssociationsRequestAssociationIdsListValue != null) {
                    request.addParameter("AssociationId." + associationIdsListIndex, StringUtils.fromString((String)describeIamInstanceProfileAssociationsRequestAssociationIdsListValue));
                }
                ++associationIdsListIndex;
            }
        }
        if ((describeIamInstanceProfileAssociationsRequestFiltersList = describeIamInstanceProfileAssociationsRequest.filters()) != null) {
            int filtersListIndex = 1;
            for (Filter describeIamInstanceProfileAssociationsRequestFiltersListValue : describeIamInstanceProfileAssociationsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeIamInstanceProfileAssociationsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeIamInstanceProfileAssociationsRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describeIamInstanceProfileAssociationsRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeIamInstanceProfileAssociationsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeIamInstanceProfileAssociationsRequest.maxResults()));
        }
        if (describeIamInstanceProfileAssociationsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeIamInstanceProfileAssociationsRequest.nextToken()));
        }
        return request;
    }
}

