/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeExportTasksRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeExportTasksRequestMarshaller
implements Marshaller<Request<DescribeExportTasksRequest>, DescribeExportTasksRequest> {
    public Request<DescribeExportTasksRequest> marshall(DescribeExportTasksRequest describeExportTasksRequest) {
        if (describeExportTasksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeExportTasksRequest, "EC2Client");
        request.addParameter("Action", "DescribeExportTasks");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeExportTasksRequestExportTaskIdsList = describeExportTasksRequest.exportTaskIds();
        if (describeExportTasksRequestExportTaskIdsList != null) {
            int exportTaskIdsListIndex = 1;
            for (String describeExportTasksRequestExportTaskIdsListValue : describeExportTasksRequestExportTaskIdsList) {
                if (describeExportTasksRequestExportTaskIdsListValue != null) {
                    request.addParameter("ExportTaskId." + exportTaskIdsListIndex, StringUtils.fromString((String)describeExportTasksRequestExportTaskIdsListValue));
                }
                ++exportTaskIdsListIndex;
            }
        }
        return request;
    }
}

