/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.CreateFlowLogsRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreateFlowLogsRequestMarshaller
implements Marshaller<Request<CreateFlowLogsRequest>, CreateFlowLogsRequest> {
    public Request<CreateFlowLogsRequest> marshall(CreateFlowLogsRequest createFlowLogsRequest) {
        List<String> createFlowLogsRequestResourceIdsList;
        if (createFlowLogsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createFlowLogsRequest, "EC2Client");
        request.addParameter("Action", "CreateFlowLogs");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createFlowLogsRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)createFlowLogsRequest.clientToken()));
        }
        if (createFlowLogsRequest.deliverLogsPermissionArn() != null) {
            request.addParameter("DeliverLogsPermissionArn", StringUtils.fromString((String)createFlowLogsRequest.deliverLogsPermissionArn()));
        }
        if (createFlowLogsRequest.logGroupName() != null) {
            request.addParameter("LogGroupName", StringUtils.fromString((String)createFlowLogsRequest.logGroupName()));
        }
        if ((createFlowLogsRequestResourceIdsList = createFlowLogsRequest.resourceIds()) != null) {
            int resourceIdsListIndex = 1;
            for (String createFlowLogsRequestResourceIdsListValue : createFlowLogsRequestResourceIdsList) {
                if (createFlowLogsRequestResourceIdsListValue != null) {
                    request.addParameter("ResourceId." + resourceIdsListIndex, StringUtils.fromString((String)createFlowLogsRequestResourceIdsListValue));
                }
                ++resourceIdsListIndex;
            }
        }
        if (createFlowLogsRequest.resourceType() != null) {
            request.addParameter("ResourceType", StringUtils.fromString((String)createFlowLogsRequest.resourceType()));
        }
        if (createFlowLogsRequest.trafficType() != null) {
            request.addParameter("TrafficType", StringUtils.fromString((String)createFlowLogsRequest.trafficType()));
        }
        return request;
    }
}

