/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceRequest;
import software.amazon.awssdk.util.StringUtils;

public class ConfirmProductInstanceRequestMarshaller
implements Marshaller<Request<ConfirmProductInstanceRequest>, ConfirmProductInstanceRequest> {
    public Request<ConfirmProductInstanceRequest> marshall(ConfirmProductInstanceRequest confirmProductInstanceRequest) {
        if (confirmProductInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)confirmProductInstanceRequest, "EC2Client");
        request.addParameter("Action", "ConfirmProductInstance");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (confirmProductInstanceRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)confirmProductInstanceRequest.instanceId()));
        }
        if (confirmProductInstanceRequest.productCode() != null) {
            request.addParameter("ProductCode", StringUtils.fromString((String)confirmProductInstanceRequest.productCode()));
        }
        return request;
    }
}

