/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.CancelImportTaskRequest;
import software.amazon.awssdk.util.StringUtils;

public class CancelImportTaskRequestMarshaller
implements Marshaller<Request<CancelImportTaskRequest>, CancelImportTaskRequest> {
    public Request<CancelImportTaskRequest> marshall(CancelImportTaskRequest cancelImportTaskRequest) {
        if (cancelImportTaskRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)cancelImportTaskRequest, "EC2Client");
        request.addParameter("Action", "CancelImportTask");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (cancelImportTaskRequest.cancelReason() != null) {
            request.addParameter("CancelReason", StringUtils.fromString((String)cancelImportTaskRequest.cancelReason()));
        }
        if (cancelImportTaskRequest.importTaskId() != null) {
            request.addParameter("ImportTaskId", StringUtils.fromString((String)cancelImportTaskRequest.importTaskId()));
        }
        return request;
    }
}

