/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.transform.EbsBlockDeviceUnmarshaller;

public class BlockDeviceMappingUnmarshaller
implements Unmarshaller<BlockDeviceMapping, StaxUnmarshallerContext> {
    private static BlockDeviceMappingUnmarshaller INSTANCE;

    public BlockDeviceMapping unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        BlockDeviceMapping.Builder blockDeviceMapping = BlockDeviceMapping.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("deviceName", targetDepth)) {
                    blockDeviceMapping.deviceName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("virtualName", targetDepth)) {
                    blockDeviceMapping.virtualName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ebs", targetDepth)) {
                    blockDeviceMapping.ebs(EbsBlockDeviceUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("noDevice", targetDepth)) continue;
                blockDeviceMapping.noDevice(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (BlockDeviceMapping)blockDeviceMapping.build();
    }

    public static BlockDeviceMappingUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BlockDeviceMappingUnmarshaller();
        }
        return INSTANCE;
    }
}

