/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import software.amazon.awssdk.services.ec2.model.TelemetryStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VgwTelemetry
implements ToCopyableBuilder<Builder, VgwTelemetry> {
    private final Integer acceptedRouteCount;
    private final Instant lastStatusChange;
    private final String outsideIpAddress;
    private final String status;
    private final String statusMessage;

    private VgwTelemetry(BuilderImpl builder) {
        this.acceptedRouteCount = builder.acceptedRouteCount;
        this.lastStatusChange = builder.lastStatusChange;
        this.outsideIpAddress = builder.outsideIpAddress;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    public Integer acceptedRouteCount() {
        return this.acceptedRouteCount;
    }

    public Instant lastStatusChange() {
        return this.lastStatusChange;
    }

    public String outsideIpAddress() {
        return this.outsideIpAddress;
    }

    public String status() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.acceptedRouteCount() == null ? 0 : this.acceptedRouteCount().hashCode());
        hashCode = 31 * hashCode + (this.lastStatusChange() == null ? 0 : this.lastStatusChange().hashCode());
        hashCode = 31 * hashCode + (this.outsideIpAddress() == null ? 0 : this.outsideIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.statusMessage() == null ? 0 : this.statusMessage().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VgwTelemetry)) {
            return false;
        }
        VgwTelemetry other = (VgwTelemetry)obj;
        if (other.acceptedRouteCount() == null ^ this.acceptedRouteCount() == null) {
            return false;
        }
        if (other.acceptedRouteCount() != null && !other.acceptedRouteCount().equals(this.acceptedRouteCount())) {
            return false;
        }
        if (other.lastStatusChange() == null ^ this.lastStatusChange() == null) {
            return false;
        }
        if (other.lastStatusChange() != null && !other.lastStatusChange().equals(this.lastStatusChange())) {
            return false;
        }
        if (other.outsideIpAddress() == null ^ this.outsideIpAddress() == null) {
            return false;
        }
        if (other.outsideIpAddress() != null && !other.outsideIpAddress().equals(this.outsideIpAddress())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusMessage() == null ^ this.statusMessage() == null) {
            return false;
        }
        return other.statusMessage() == null || other.statusMessage().equals(this.statusMessage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.acceptedRouteCount() != null) {
            sb.append("AcceptedRouteCount: ").append(this.acceptedRouteCount()).append(",");
        }
        if (this.lastStatusChange() != null) {
            sb.append("LastStatusChange: ").append(this.lastStatusChange()).append(",");
        }
        if (this.outsideIpAddress() != null) {
            sb.append("OutsideIpAddress: ").append(this.outsideIpAddress()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.statusMessage() != null) {
            sb.append("StatusMessage: ").append(this.statusMessage()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer acceptedRouteCount;
        private Instant lastStatusChange;
        private String outsideIpAddress;
        private String status;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(VgwTelemetry model) {
            this.setAcceptedRouteCount(model.acceptedRouteCount);
            this.setLastStatusChange(model.lastStatusChange);
            this.setOutsideIpAddress(model.outsideIpAddress);
            this.setStatus(model.status);
            this.setStatusMessage(model.statusMessage);
        }

        public final Integer getAcceptedRouteCount() {
            return this.acceptedRouteCount;
        }

        @Override
        public final Builder acceptedRouteCount(Integer acceptedRouteCount) {
            this.acceptedRouteCount = acceptedRouteCount;
            return this;
        }

        public final void setAcceptedRouteCount(Integer acceptedRouteCount) {
            this.acceptedRouteCount = acceptedRouteCount;
        }

        public final Instant getLastStatusChange() {
            return this.lastStatusChange;
        }

        @Override
        public final Builder lastStatusChange(Instant lastStatusChange) {
            this.lastStatusChange = lastStatusChange;
            return this;
        }

        public final void setLastStatusChange(Instant lastStatusChange) {
            this.lastStatusChange = lastStatusChange;
        }

        public final String getOutsideIpAddress() {
            return this.outsideIpAddress;
        }

        @Override
        public final Builder outsideIpAddress(String outsideIpAddress) {
            this.outsideIpAddress = outsideIpAddress;
            return this;
        }

        public final void setOutsideIpAddress(String outsideIpAddress) {
            this.outsideIpAddress = outsideIpAddress;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TelemetryStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(TelemetryStatus status) {
            this.status(status.toString());
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public VgwTelemetry build() {
            return new VgwTelemetry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VgwTelemetry> {
        public Builder acceptedRouteCount(Integer var1);

        public Builder lastStatusChange(Instant var1);

        public Builder outsideIpAddress(String var1);

        public Builder status(String var1);

        public Builder status(TelemetryStatus var1);

        public Builder statusMessage(String var1);
    }
}

