/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import software.amazon.awssdk.services.ec2.model.ActivityStatus;
import software.amazon.awssdk.services.ec2.model.BatchState;
import software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfigData;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SpotFleetRequestConfig
implements ToCopyableBuilder<Builder, SpotFleetRequestConfig> {
    private final String activityStatus;
    private final Instant createTime;
    private final SpotFleetRequestConfigData spotFleetRequestConfig;
    private final String spotFleetRequestId;
    private final String spotFleetRequestState;

    private SpotFleetRequestConfig(BuilderImpl builder) {
        this.activityStatus = builder.activityStatus;
        this.createTime = builder.createTime;
        this.spotFleetRequestConfig = builder.spotFleetRequestConfig;
        this.spotFleetRequestId = builder.spotFleetRequestId;
        this.spotFleetRequestState = builder.spotFleetRequestState;
    }

    public String activityStatus() {
        return this.activityStatus;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public SpotFleetRequestConfigData spotFleetRequestConfig() {
        return this.spotFleetRequestConfig;
    }

    public String spotFleetRequestId() {
        return this.spotFleetRequestId;
    }

    public String spotFleetRequestState() {
        return this.spotFleetRequestState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.activityStatus() == null ? 0 : this.activityStatus().hashCode());
        hashCode = 31 * hashCode + (this.createTime() == null ? 0 : this.createTime().hashCode());
        hashCode = 31 * hashCode + (this.spotFleetRequestConfig() == null ? 0 : this.spotFleetRequestConfig().hashCode());
        hashCode = 31 * hashCode + (this.spotFleetRequestId() == null ? 0 : this.spotFleetRequestId().hashCode());
        hashCode = 31 * hashCode + (this.spotFleetRequestState() == null ? 0 : this.spotFleetRequestState().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotFleetRequestConfig)) {
            return false;
        }
        SpotFleetRequestConfig other = (SpotFleetRequestConfig)obj;
        if (other.activityStatus() == null ^ this.activityStatus() == null) {
            return false;
        }
        if (other.activityStatus() != null && !other.activityStatus().equals(this.activityStatus())) {
            return false;
        }
        if (other.createTime() == null ^ this.createTime() == null) {
            return false;
        }
        if (other.createTime() != null && !other.createTime().equals(this.createTime())) {
            return false;
        }
        if (other.spotFleetRequestConfig() == null ^ this.spotFleetRequestConfig() == null) {
            return false;
        }
        if (other.spotFleetRequestConfig() != null && !other.spotFleetRequestConfig().equals(this.spotFleetRequestConfig())) {
            return false;
        }
        if (other.spotFleetRequestId() == null ^ this.spotFleetRequestId() == null) {
            return false;
        }
        if (other.spotFleetRequestId() != null && !other.spotFleetRequestId().equals(this.spotFleetRequestId())) {
            return false;
        }
        if (other.spotFleetRequestState() == null ^ this.spotFleetRequestState() == null) {
            return false;
        }
        return other.spotFleetRequestState() == null || other.spotFleetRequestState().equals(this.spotFleetRequestState());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.activityStatus() != null) {
            sb.append("ActivityStatus: ").append(this.activityStatus()).append(",");
        }
        if (this.createTime() != null) {
            sb.append("CreateTime: ").append(this.createTime()).append(",");
        }
        if (this.spotFleetRequestConfig() != null) {
            sb.append("SpotFleetRequestConfig: ").append(this.spotFleetRequestConfig()).append(",");
        }
        if (this.spotFleetRequestId() != null) {
            sb.append("SpotFleetRequestId: ").append(this.spotFleetRequestId()).append(",");
        }
        if (this.spotFleetRequestState() != null) {
            sb.append("SpotFleetRequestState: ").append(this.spotFleetRequestState()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String activityStatus;
        private Instant createTime;
        private SpotFleetRequestConfigData spotFleetRequestConfig;
        private String spotFleetRequestId;
        private String spotFleetRequestState;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotFleetRequestConfig model) {
            this.setActivityStatus(model.activityStatus);
            this.setCreateTime(model.createTime);
            this.setSpotFleetRequestConfig(model.spotFleetRequestConfig);
            this.setSpotFleetRequestId(model.spotFleetRequestId);
            this.setSpotFleetRequestState(model.spotFleetRequestState);
        }

        public final String getActivityStatus() {
            return this.activityStatus;
        }

        @Override
        public final Builder activityStatus(String activityStatus) {
            this.activityStatus = activityStatus;
            return this;
        }

        @Override
        public final Builder activityStatus(ActivityStatus activityStatus) {
            this.activityStatus(activityStatus.toString());
            return this;
        }

        public final void setActivityStatus(String activityStatus) {
            this.activityStatus = activityStatus;
        }

        public final void setActivityStatus(ActivityStatus activityStatus) {
            this.activityStatus(activityStatus.toString());
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final SpotFleetRequestConfigData getSpotFleetRequestConfig() {
            return this.spotFleetRequestConfig;
        }

        @Override
        public final Builder spotFleetRequestConfig(SpotFleetRequestConfigData spotFleetRequestConfig) {
            this.spotFleetRequestConfig = spotFleetRequestConfig;
            return this;
        }

        public final void setSpotFleetRequestConfig(SpotFleetRequestConfigData spotFleetRequestConfig) {
            this.spotFleetRequestConfig = spotFleetRequestConfig;
        }

        public final String getSpotFleetRequestId() {
            return this.spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        public final String getSpotFleetRequestState() {
            return this.spotFleetRequestState;
        }

        @Override
        public final Builder spotFleetRequestState(String spotFleetRequestState) {
            this.spotFleetRequestState = spotFleetRequestState;
            return this;
        }

        @Override
        public final Builder spotFleetRequestState(BatchState spotFleetRequestState) {
            this.spotFleetRequestState(spotFleetRequestState.toString());
            return this;
        }

        public final void setSpotFleetRequestState(String spotFleetRequestState) {
            this.spotFleetRequestState = spotFleetRequestState;
        }

        public final void setSpotFleetRequestState(BatchState spotFleetRequestState) {
            this.spotFleetRequestState(spotFleetRequestState.toString());
        }

        public SpotFleetRequestConfig build() {
            return new SpotFleetRequestConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SpotFleetRequestConfig> {
        public Builder activityStatus(String var1);

        public Builder activityStatus(ActivityStatus var1);

        public Builder createTime(Instant var1);

        public Builder spotFleetRequestConfig(SpotFleetRequestConfigData var1);

        public Builder spotFleetRequestId(String var1);

        public Builder spotFleetRequestState(String var1);

        public Builder spotFleetRequestState(BatchState var1);
    }
}

