/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMappingListCopier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifierListCopier;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.SpotFleetMonitoring;
import software.amazon.awssdk.services.ec2.model.SpotPlacement;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SpotFleetLaunchSpecification
implements ToCopyableBuilder<Builder, SpotFleetLaunchSpecification> {
    private final List<GroupIdentifier> securityGroups;
    private final String addressingType;
    private final List<BlockDeviceMapping> blockDeviceMappings;
    private final Boolean ebsOptimized;
    private final IamInstanceProfileSpecification iamInstanceProfile;
    private final String imageId;
    private final String instanceType;
    private final String kernelId;
    private final String keyName;
    private final SpotFleetMonitoring monitoring;
    private final List<InstanceNetworkInterfaceSpecification> networkInterfaces;
    private final SpotPlacement placement;
    private final String ramdiskId;
    private final String spotPrice;
    private final String subnetId;
    private final String userData;
    private final Double weightedCapacity;

    private SpotFleetLaunchSpecification(BuilderImpl builder) {
        this.securityGroups = builder.securityGroups;
        this.addressingType = builder.addressingType;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.monitoring = builder.monitoring;
        this.networkInterfaces = builder.networkInterfaces;
        this.placement = builder.placement;
        this.ramdiskId = builder.ramdiskId;
        this.spotPrice = builder.spotPrice;
        this.subnetId = builder.subnetId;
        this.userData = builder.userData;
        this.weightedCapacity = builder.weightedCapacity;
    }

    public List<GroupIdentifier> securityGroups() {
        return this.securityGroups;
    }

    public String addressingType() {
        return this.addressingType;
    }

    public List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public IamInstanceProfileSpecification iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public String imageId() {
        return this.imageId;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String kernelId() {
        return this.kernelId;
    }

    public String keyName() {
        return this.keyName;
    }

    public SpotFleetMonitoring monitoring() {
        return this.monitoring;
    }

    public List<InstanceNetworkInterfaceSpecification> networkInterfaces() {
        return this.networkInterfaces;
    }

    public SpotPlacement placement() {
        return this.placement;
    }

    public String ramdiskId() {
        return this.ramdiskId;
    }

    public String spotPrice() {
        return this.spotPrice;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String userData() {
        return this.userData;
    }

    public Double weightedCapacity() {
        return this.weightedCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.securityGroups() == null ? 0 : this.securityGroups().hashCode());
        hashCode = 31 * hashCode + (this.addressingType() == null ? 0 : this.addressingType().hashCode());
        hashCode = 31 * hashCode + (this.blockDeviceMappings() == null ? 0 : this.blockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.ebsOptimized() == null ? 0 : this.ebsOptimized().hashCode());
        hashCode = 31 * hashCode + (this.iamInstanceProfile() == null ? 0 : this.iamInstanceProfile().hashCode());
        hashCode = 31 * hashCode + (this.imageId() == null ? 0 : this.imageId().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.kernelId() == null ? 0 : this.kernelId().hashCode());
        hashCode = 31 * hashCode + (this.keyName() == null ? 0 : this.keyName().hashCode());
        hashCode = 31 * hashCode + (this.monitoring() == null ? 0 : this.monitoring().hashCode());
        hashCode = 31 * hashCode + (this.networkInterfaces() == null ? 0 : this.networkInterfaces().hashCode());
        hashCode = 31 * hashCode + (this.placement() == null ? 0 : this.placement().hashCode());
        hashCode = 31 * hashCode + (this.ramdiskId() == null ? 0 : this.ramdiskId().hashCode());
        hashCode = 31 * hashCode + (this.spotPrice() == null ? 0 : this.spotPrice().hashCode());
        hashCode = 31 * hashCode + (this.subnetId() == null ? 0 : this.subnetId().hashCode());
        hashCode = 31 * hashCode + (this.userData() == null ? 0 : this.userData().hashCode());
        hashCode = 31 * hashCode + (this.weightedCapacity() == null ? 0 : this.weightedCapacity().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotFleetLaunchSpecification)) {
            return false;
        }
        SpotFleetLaunchSpecification other = (SpotFleetLaunchSpecification)obj;
        if (other.securityGroups() == null ^ this.securityGroups() == null) {
            return false;
        }
        if (other.securityGroups() != null && !other.securityGroups().equals(this.securityGroups())) {
            return false;
        }
        if (other.addressingType() == null ^ this.addressingType() == null) {
            return false;
        }
        if (other.addressingType() != null && !other.addressingType().equals(this.addressingType())) {
            return false;
        }
        if (other.blockDeviceMappings() == null ^ this.blockDeviceMappings() == null) {
            return false;
        }
        if (other.blockDeviceMappings() != null && !other.blockDeviceMappings().equals(this.blockDeviceMappings())) {
            return false;
        }
        if (other.ebsOptimized() == null ^ this.ebsOptimized() == null) {
            return false;
        }
        if (other.ebsOptimized() != null && !other.ebsOptimized().equals(this.ebsOptimized())) {
            return false;
        }
        if (other.iamInstanceProfile() == null ^ this.iamInstanceProfile() == null) {
            return false;
        }
        if (other.iamInstanceProfile() != null && !other.iamInstanceProfile().equals(this.iamInstanceProfile())) {
            return false;
        }
        if (other.imageId() == null ^ this.imageId() == null) {
            return false;
        }
        if (other.imageId() != null && !other.imageId().equals(this.imageId())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.kernelId() == null ^ this.kernelId() == null) {
            return false;
        }
        if (other.kernelId() != null && !other.kernelId().equals(this.kernelId())) {
            return false;
        }
        if (other.keyName() == null ^ this.keyName() == null) {
            return false;
        }
        if (other.keyName() != null && !other.keyName().equals(this.keyName())) {
            return false;
        }
        if (other.monitoring() == null ^ this.monitoring() == null) {
            return false;
        }
        if (other.monitoring() != null && !other.monitoring().equals(this.monitoring())) {
            return false;
        }
        if (other.networkInterfaces() == null ^ this.networkInterfaces() == null) {
            return false;
        }
        if (other.networkInterfaces() != null && !other.networkInterfaces().equals(this.networkInterfaces())) {
            return false;
        }
        if (other.placement() == null ^ this.placement() == null) {
            return false;
        }
        if (other.placement() != null && !other.placement().equals(this.placement())) {
            return false;
        }
        if (other.ramdiskId() == null ^ this.ramdiskId() == null) {
            return false;
        }
        if (other.ramdiskId() != null && !other.ramdiskId().equals(this.ramdiskId())) {
            return false;
        }
        if (other.spotPrice() == null ^ this.spotPrice() == null) {
            return false;
        }
        if (other.spotPrice() != null && !other.spotPrice().equals(this.spotPrice())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        if (other.userData() == null ^ this.userData() == null) {
            return false;
        }
        if (other.userData() != null && !other.userData().equals(this.userData())) {
            return false;
        }
        if (other.weightedCapacity() == null ^ this.weightedCapacity() == null) {
            return false;
        }
        return other.weightedCapacity() == null || other.weightedCapacity().equals(this.weightedCapacity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.securityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.securityGroups()).append(",");
        }
        if (this.addressingType() != null) {
            sb.append("AddressingType: ").append(this.addressingType()).append(",");
        }
        if (this.blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.blockDeviceMappings()).append(",");
        }
        if (this.ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.ebsOptimized()).append(",");
        }
        if (this.iamInstanceProfile() != null) {
            sb.append("IamInstanceProfile: ").append(this.iamInstanceProfile()).append(",");
        }
        if (this.imageId() != null) {
            sb.append("ImageId: ").append(this.imageId()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.kernelId() != null) {
            sb.append("KernelId: ").append(this.kernelId()).append(",");
        }
        if (this.keyName() != null) {
            sb.append("KeyName: ").append(this.keyName()).append(",");
        }
        if (this.monitoring() != null) {
            sb.append("Monitoring: ").append(this.monitoring()).append(",");
        }
        if (this.networkInterfaces() != null) {
            sb.append("NetworkInterfaces: ").append(this.networkInterfaces()).append(",");
        }
        if (this.placement() != null) {
            sb.append("Placement: ").append(this.placement()).append(",");
        }
        if (this.ramdiskId() != null) {
            sb.append("RamdiskId: ").append(this.ramdiskId()).append(",");
        }
        if (this.spotPrice() != null) {
            sb.append("SpotPrice: ").append(this.spotPrice()).append(",");
        }
        if (this.subnetId() != null) {
            sb.append("SubnetId: ").append(this.subnetId()).append(",");
        }
        if (this.userData() != null) {
            sb.append("UserData: ").append(this.userData()).append(",");
        }
        if (this.weightedCapacity() != null) {
            sb.append("WeightedCapacity: ").append(this.weightedCapacity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<GroupIdentifier> securityGroups;
        private String addressingType;
        private List<BlockDeviceMapping> blockDeviceMappings;
        private Boolean ebsOptimized;
        private IamInstanceProfileSpecification iamInstanceProfile;
        private String imageId;
        private String instanceType;
        private String kernelId;
        private String keyName;
        private SpotFleetMonitoring monitoring;
        private List<InstanceNetworkInterfaceSpecification> networkInterfaces;
        private SpotPlacement placement;
        private String ramdiskId;
        private String spotPrice;
        private String subnetId;
        private String userData;
        private Double weightedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotFleetLaunchSpecification model) {
            this.setSecurityGroups(model.securityGroups);
            this.setAddressingType(model.addressingType);
            this.setBlockDeviceMappings(model.blockDeviceMappings);
            this.setEbsOptimized(model.ebsOptimized);
            this.setIamInstanceProfile(model.iamInstanceProfile);
            this.setImageId(model.imageId);
            this.setInstanceType(model.instanceType);
            this.setKernelId(model.kernelId);
            this.setKeyName(model.keyName);
            this.setMonitoring(model.monitoring);
            this.setNetworkInterfaces(model.networkInterfaces);
            this.setPlacement(model.placement);
            this.setRamdiskId(model.ramdiskId);
            this.setSpotPrice(model.spotPrice);
            this.setSubnetId(model.subnetId);
            this.setUserData(model.userData);
            this.setWeightedCapacity(model.weightedCapacity);
        }

        public final Collection<GroupIdentifier> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<GroupIdentifier> securityGroups) {
            this.securityGroups = GroupIdentifierListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(GroupIdentifier ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<GroupIdentifier> securityGroups) {
            this.securityGroups = GroupIdentifierListCopier.copy(securityGroups);
        }

        @SafeVarargs
        public final void setSecurityGroups(GroupIdentifier ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
        }

        public final String getAddressingType() {
            return this.addressingType;
        }

        @Override
        public final Builder addressingType(String addressingType) {
            this.addressingType = addressingType;
            return this;
        }

        public final void setAddressingType(String addressingType) {
            this.addressingType = addressingType;
        }

        public final Collection<BlockDeviceMapping> getBlockDeviceMappings() {
            return this.blockDeviceMappings;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
        }

        @SafeVarargs
        public final void setBlockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final IamInstanceProfileSpecification getIamInstanceProfile() {
            return this.iamInstanceProfile;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final void setInstanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final SpotFleetMonitoring getMonitoring() {
            return this.monitoring;
        }

        @Override
        public final Builder monitoring(SpotFleetMonitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(SpotFleetMonitoring monitoring) {
            this.monitoring = monitoring;
        }

        public final Collection<InstanceNetworkInterfaceSpecification> getNetworkInterfaces() {
            return this.networkInterfaces;
        }

        @Override
        public final Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(InstanceNetworkInterfaceSpecification ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        public final void setNetworkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copy(networkInterfaces);
        }

        @SafeVarargs
        public final void setNetworkInterfaces(InstanceNetworkInterfaceSpecification ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
        }

        public final SpotPlacement getPlacement() {
            return this.placement;
        }

        @Override
        public final Builder placement(SpotPlacement placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(SpotPlacement placement) {
            this.placement = placement;
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final String getSpotPrice() {
            return this.spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getUserData() {
            return this.userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final Double getWeightedCapacity() {
            return this.weightedCapacity;
        }

        @Override
        public final Builder weightedCapacity(Double weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
            return this;
        }

        public final void setWeightedCapacity(Double weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
        }

        public SpotFleetLaunchSpecification build() {
            return new SpotFleetLaunchSpecification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SpotFleetLaunchSpecification> {
        public Builder securityGroups(Collection<GroupIdentifier> var1);

        public Builder securityGroups(GroupIdentifier ... var1);

        public Builder addressingType(String var1);

        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder iamInstanceProfile(IamInstanceProfileSpecification var1);

        public Builder imageId(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder kernelId(String var1);

        public Builder keyName(String var1);

        public Builder monitoring(SpotFleetMonitoring var1);

        public Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> var1);

        public Builder networkInterfaces(InstanceNetworkInterfaceSpecification ... var1);

        public Builder placement(SpotPlacement var1);

        public Builder ramdiskId(String var1);

        public Builder spotPrice(String var1);

        public Builder subnetId(String var1);

        public Builder userData(String var1);

        public Builder weightedCapacity(Double var1);
    }
}

