/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.OccurrenceDayRequestSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ScheduledInstanceRecurrenceRequest
implements ToCopyableBuilder<Builder, ScheduledInstanceRecurrenceRequest> {
    private final String frequency;
    private final Integer interval;
    private final List<Integer> occurrenceDays;
    private final Boolean occurrenceRelativeToEnd;
    private final String occurrenceUnit;

    private ScheduledInstanceRecurrenceRequest(BuilderImpl builder) {
        this.frequency = builder.frequency;
        this.interval = builder.interval;
        this.occurrenceDays = builder.occurrenceDays;
        this.occurrenceRelativeToEnd = builder.occurrenceRelativeToEnd;
        this.occurrenceUnit = builder.occurrenceUnit;
    }

    public String frequency() {
        return this.frequency;
    }

    public Integer interval() {
        return this.interval;
    }

    public List<Integer> occurrenceDays() {
        return this.occurrenceDays;
    }

    public Boolean occurrenceRelativeToEnd() {
        return this.occurrenceRelativeToEnd;
    }

    public String occurrenceUnit() {
        return this.occurrenceUnit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.frequency() == null ? 0 : this.frequency().hashCode());
        hashCode = 31 * hashCode + (this.interval() == null ? 0 : this.interval().hashCode());
        hashCode = 31 * hashCode + (this.occurrenceDays() == null ? 0 : this.occurrenceDays().hashCode());
        hashCode = 31 * hashCode + (this.occurrenceRelativeToEnd() == null ? 0 : this.occurrenceRelativeToEnd().hashCode());
        hashCode = 31 * hashCode + (this.occurrenceUnit() == null ? 0 : this.occurrenceUnit().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstanceRecurrenceRequest)) {
            return false;
        }
        ScheduledInstanceRecurrenceRequest other = (ScheduledInstanceRecurrenceRequest)obj;
        if (other.frequency() == null ^ this.frequency() == null) {
            return false;
        }
        if (other.frequency() != null && !other.frequency().equals(this.frequency())) {
            return false;
        }
        if (other.interval() == null ^ this.interval() == null) {
            return false;
        }
        if (other.interval() != null && !other.interval().equals(this.interval())) {
            return false;
        }
        if (other.occurrenceDays() == null ^ this.occurrenceDays() == null) {
            return false;
        }
        if (other.occurrenceDays() != null && !other.occurrenceDays().equals(this.occurrenceDays())) {
            return false;
        }
        if (other.occurrenceRelativeToEnd() == null ^ this.occurrenceRelativeToEnd() == null) {
            return false;
        }
        if (other.occurrenceRelativeToEnd() != null && !other.occurrenceRelativeToEnd().equals(this.occurrenceRelativeToEnd())) {
            return false;
        }
        if (other.occurrenceUnit() == null ^ this.occurrenceUnit() == null) {
            return false;
        }
        return other.occurrenceUnit() == null || other.occurrenceUnit().equals(this.occurrenceUnit());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.frequency() != null) {
            sb.append("Frequency: ").append(this.frequency()).append(",");
        }
        if (this.interval() != null) {
            sb.append("Interval: ").append(this.interval()).append(",");
        }
        if (this.occurrenceDays() != null) {
            sb.append("OccurrenceDays: ").append(this.occurrenceDays()).append(",");
        }
        if (this.occurrenceRelativeToEnd() != null) {
            sb.append("OccurrenceRelativeToEnd: ").append(this.occurrenceRelativeToEnd()).append(",");
        }
        if (this.occurrenceUnit() != null) {
            sb.append("OccurrenceUnit: ").append(this.occurrenceUnit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String frequency;
        private Integer interval;
        private List<Integer> occurrenceDays;
        private Boolean occurrenceRelativeToEnd;
        private String occurrenceUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstanceRecurrenceRequest model) {
            this.setFrequency(model.frequency);
            this.setInterval(model.interval);
            this.setOccurrenceDays(model.occurrenceDays);
            this.setOccurrenceRelativeToEnd(model.occurrenceRelativeToEnd);
            this.setOccurrenceUnit(model.occurrenceUnit);
        }

        public final String getFrequency() {
            return this.frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        public final Integer getInterval() {
            return this.interval;
        }

        @Override
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        public final Collection<Integer> getOccurrenceDays() {
            return this.occurrenceDays;
        }

        @Override
        public final Builder occurrenceDays(Collection<Integer> occurrenceDays) {
            this.occurrenceDays = OccurrenceDayRequestSetCopier.copy(occurrenceDays);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder occurrenceDays(Integer ... occurrenceDays) {
            this.occurrenceDays(Arrays.asList(occurrenceDays));
            return this;
        }

        public final void setOccurrenceDays(Collection<Integer> occurrenceDays) {
            this.occurrenceDays = OccurrenceDayRequestSetCopier.copy(occurrenceDays);
        }

        @SafeVarargs
        public final void setOccurrenceDays(Integer ... occurrenceDays) {
            this.occurrenceDays(Arrays.asList(occurrenceDays));
        }

        public final Boolean getOccurrenceRelativeToEnd() {
            return this.occurrenceRelativeToEnd;
        }

        @Override
        public final Builder occurrenceRelativeToEnd(Boolean occurrenceRelativeToEnd) {
            this.occurrenceRelativeToEnd = occurrenceRelativeToEnd;
            return this;
        }

        public final void setOccurrenceRelativeToEnd(Boolean occurrenceRelativeToEnd) {
            this.occurrenceRelativeToEnd = occurrenceRelativeToEnd;
        }

        public final String getOccurrenceUnit() {
            return this.occurrenceUnit;
        }

        @Override
        public final Builder occurrenceUnit(String occurrenceUnit) {
            this.occurrenceUnit = occurrenceUnit;
            return this;
        }

        public final void setOccurrenceUnit(String occurrenceUnit) {
            this.occurrenceUnit = occurrenceUnit;
        }

        public ScheduledInstanceRecurrenceRequest build() {
            return new ScheduledInstanceRecurrenceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScheduledInstanceRecurrenceRequest> {
        public Builder frequency(String var1);

        public Builder interval(Integer var1);

        public Builder occurrenceDays(Collection<Integer> var1);

        public Builder occurrenceDays(Integer ... var1);

        public Builder occurrenceRelativeToEnd(Boolean var1);

        public Builder occurrenceUnit(String var1);
    }
}

