/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ProvisionedBandwidth
implements ToCopyableBuilder<Builder, ProvisionedBandwidth> {
    private final Instant provisionTime;
    private final String provisioned;
    private final Instant requestTime;
    private final String requested;
    private final String status;

    private ProvisionedBandwidth(BuilderImpl builder) {
        this.provisionTime = builder.provisionTime;
        this.provisioned = builder.provisioned;
        this.requestTime = builder.requestTime;
        this.requested = builder.requested;
        this.status = builder.status;
    }

    public Instant provisionTime() {
        return this.provisionTime;
    }

    public String provisioned() {
        return this.provisioned;
    }

    public Instant requestTime() {
        return this.requestTime;
    }

    public String requested() {
        return this.requested;
    }

    public String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.provisionTime() == null ? 0 : this.provisionTime().hashCode());
        hashCode = 31 * hashCode + (this.provisioned() == null ? 0 : this.provisioned().hashCode());
        hashCode = 31 * hashCode + (this.requestTime() == null ? 0 : this.requestTime().hashCode());
        hashCode = 31 * hashCode + (this.requested() == null ? 0 : this.requested().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedBandwidth)) {
            return false;
        }
        ProvisionedBandwidth other = (ProvisionedBandwidth)obj;
        if (other.provisionTime() == null ^ this.provisionTime() == null) {
            return false;
        }
        if (other.provisionTime() != null && !other.provisionTime().equals(this.provisionTime())) {
            return false;
        }
        if (other.provisioned() == null ^ this.provisioned() == null) {
            return false;
        }
        if (other.provisioned() != null && !other.provisioned().equals(this.provisioned())) {
            return false;
        }
        if (other.requestTime() == null ^ this.requestTime() == null) {
            return false;
        }
        if (other.requestTime() != null && !other.requestTime().equals(this.requestTime())) {
            return false;
        }
        if (other.requested() == null ^ this.requested() == null) {
            return false;
        }
        if (other.requested() != null && !other.requested().equals(this.requested())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        return other.status() == null || other.status().equals(this.status());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.provisionTime() != null) {
            sb.append("ProvisionTime: ").append(this.provisionTime()).append(",");
        }
        if (this.provisioned() != null) {
            sb.append("Provisioned: ").append(this.provisioned()).append(",");
        }
        if (this.requestTime() != null) {
            sb.append("RequestTime: ").append(this.requestTime()).append(",");
        }
        if (this.requested() != null) {
            sb.append("Requested: ").append(this.requested()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Instant provisionTime;
        private String provisioned;
        private Instant requestTime;
        private String requested;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedBandwidth model) {
            this.setProvisionTime(model.provisionTime);
            this.setProvisioned(model.provisioned);
            this.setRequestTime(model.requestTime);
            this.setRequested(model.requested);
            this.setStatus(model.status);
        }

        public final Instant getProvisionTime() {
            return this.provisionTime;
        }

        @Override
        public final Builder provisionTime(Instant provisionTime) {
            this.provisionTime = provisionTime;
            return this;
        }

        public final void setProvisionTime(Instant provisionTime) {
            this.provisionTime = provisionTime;
        }

        public final String getProvisioned() {
            return this.provisioned;
        }

        @Override
        public final Builder provisioned(String provisioned) {
            this.provisioned = provisioned;
            return this;
        }

        public final void setProvisioned(String provisioned) {
            this.provisioned = provisioned;
        }

        public final Instant getRequestTime() {
            return this.requestTime;
        }

        @Override
        public final Builder requestTime(Instant requestTime) {
            this.requestTime = requestTime;
            return this;
        }

        public final void setRequestTime(Instant requestTime) {
            this.requestTime = requestTime;
        }

        public final String getRequested() {
            return this.requested;
        }

        @Override
        public final Builder requested(String requested) {
            this.requested = requested;
            return this;
        }

        public final void setRequested(String requested) {
            this.requested = requested;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public ProvisionedBandwidth build() {
            return new ProvisionedBandwidth(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProvisionedBandwidth> {
        public Builder provisionTime(Instant var1);

        public Builder provisioned(String var1);

        public Builder requestTime(Instant var1);

        public Builder requested(String var1);

        public Builder status(String var1);
    }
}

