/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.InstanceStatusDetails;
import software.amazon.awssdk.services.ec2.model.InstanceStatusDetailsListCopier;
import software.amazon.awssdk.services.ec2.model.SummaryStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceStatusSummary
implements ToCopyableBuilder<Builder, InstanceStatusSummary> {
    private final List<InstanceStatusDetails> details;
    private final String status;

    private InstanceStatusSummary(BuilderImpl builder) {
        this.details = builder.details;
        this.status = builder.status;
    }

    public List<InstanceStatusDetails> details() {
        return this.details;
    }

    public String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.details() == null ? 0 : this.details().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStatusSummary)) {
            return false;
        }
        InstanceStatusSummary other = (InstanceStatusSummary)obj;
        if (other.details() == null ^ this.details() == null) {
            return false;
        }
        if (other.details() != null && !other.details().equals(this.details())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        return other.status() == null || other.status().equals(this.status());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.details() != null) {
            sb.append("Details: ").append(this.details()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<InstanceStatusDetails> details;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStatusSummary model) {
            this.setDetails(model.details);
            this.setStatus(model.status);
        }

        public final Collection<InstanceStatusDetails> getDetails() {
            return this.details;
        }

        @Override
        public final Builder details(Collection<InstanceStatusDetails> details) {
            this.details = InstanceStatusDetailsListCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(InstanceStatusDetails ... details) {
            this.details(Arrays.asList(details));
            return this;
        }

        public final void setDetails(Collection<InstanceStatusDetails> details) {
            this.details = InstanceStatusDetailsListCopier.copy(details);
        }

        @SafeVarargs
        public final void setDetails(InstanceStatusDetails ... details) {
            this.details(Arrays.asList(details));
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SummaryStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(SummaryStatus status) {
            this.status(status.toString());
        }

        public InstanceStatusSummary build() {
            return new InstanceStatusSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceStatusSummary> {
        public Builder details(Collection<InstanceStatusDetails> var1);

        public Builder details(InstanceStatusDetails ... var1);

        public Builder status(String var1);

        public Builder status(SummaryStatus var1);
    }
}

