/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.SnapshotDetail;
import software.amazon.awssdk.services.ec2.model.SnapshotDetailListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImportImageResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ImportImageResponse> {
    private final String architecture;
    private final String description;
    private final String hypervisor;
    private final String imageId;
    private final String importTaskId;
    private final String licenseType;
    private final String platform;
    private final String progress;
    private final List<SnapshotDetail> snapshotDetails;
    private final String status;
    private final String statusMessage;

    private ImportImageResponse(BuilderImpl builder) {
        this.architecture = builder.architecture;
        this.description = builder.description;
        this.hypervisor = builder.hypervisor;
        this.imageId = builder.imageId;
        this.importTaskId = builder.importTaskId;
        this.licenseType = builder.licenseType;
        this.platform = builder.platform;
        this.progress = builder.progress;
        this.snapshotDetails = builder.snapshotDetails;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    public String architecture() {
        return this.architecture;
    }

    public String description() {
        return this.description;
    }

    public String hypervisor() {
        return this.hypervisor;
    }

    public String imageId() {
        return this.imageId;
    }

    public String importTaskId() {
        return this.importTaskId;
    }

    public String licenseType() {
        return this.licenseType;
    }

    public String platform() {
        return this.platform;
    }

    public String progress() {
        return this.progress;
    }

    public List<SnapshotDetail> snapshotDetails() {
        return this.snapshotDetails;
    }

    public String status() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.architecture() == null ? 0 : this.architecture().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.hypervisor() == null ? 0 : this.hypervisor().hashCode());
        hashCode = 31 * hashCode + (this.imageId() == null ? 0 : this.imageId().hashCode());
        hashCode = 31 * hashCode + (this.importTaskId() == null ? 0 : this.importTaskId().hashCode());
        hashCode = 31 * hashCode + (this.licenseType() == null ? 0 : this.licenseType().hashCode());
        hashCode = 31 * hashCode + (this.platform() == null ? 0 : this.platform().hashCode());
        hashCode = 31 * hashCode + (this.progress() == null ? 0 : this.progress().hashCode());
        hashCode = 31 * hashCode + (this.snapshotDetails() == null ? 0 : this.snapshotDetails().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.statusMessage() == null ? 0 : this.statusMessage().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportImageResponse)) {
            return false;
        }
        ImportImageResponse other = (ImportImageResponse)((Object)obj);
        if (other.architecture() == null ^ this.architecture() == null) {
            return false;
        }
        if (other.architecture() != null && !other.architecture().equals(this.architecture())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.hypervisor() == null ^ this.hypervisor() == null) {
            return false;
        }
        if (other.hypervisor() != null && !other.hypervisor().equals(this.hypervisor())) {
            return false;
        }
        if (other.imageId() == null ^ this.imageId() == null) {
            return false;
        }
        if (other.imageId() != null && !other.imageId().equals(this.imageId())) {
            return false;
        }
        if (other.importTaskId() == null ^ this.importTaskId() == null) {
            return false;
        }
        if (other.importTaskId() != null && !other.importTaskId().equals(this.importTaskId())) {
            return false;
        }
        if (other.licenseType() == null ^ this.licenseType() == null) {
            return false;
        }
        if (other.licenseType() != null && !other.licenseType().equals(this.licenseType())) {
            return false;
        }
        if (other.platform() == null ^ this.platform() == null) {
            return false;
        }
        if (other.platform() != null && !other.platform().equals(this.platform())) {
            return false;
        }
        if (other.progress() == null ^ this.progress() == null) {
            return false;
        }
        if (other.progress() != null && !other.progress().equals(this.progress())) {
            return false;
        }
        if (other.snapshotDetails() == null ^ this.snapshotDetails() == null) {
            return false;
        }
        if (other.snapshotDetails() != null && !other.snapshotDetails().equals(this.snapshotDetails())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusMessage() == null ^ this.statusMessage() == null) {
            return false;
        }
        return other.statusMessage() == null || other.statusMessage().equals(this.statusMessage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.architecture() != null) {
            sb.append("Architecture: ").append(this.architecture()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.hypervisor() != null) {
            sb.append("Hypervisor: ").append(this.hypervisor()).append(",");
        }
        if (this.imageId() != null) {
            sb.append("ImageId: ").append(this.imageId()).append(",");
        }
        if (this.importTaskId() != null) {
            sb.append("ImportTaskId: ").append(this.importTaskId()).append(",");
        }
        if (this.licenseType() != null) {
            sb.append("LicenseType: ").append(this.licenseType()).append(",");
        }
        if (this.platform() != null) {
            sb.append("Platform: ").append(this.platform()).append(",");
        }
        if (this.progress() != null) {
            sb.append("Progress: ").append(this.progress()).append(",");
        }
        if (this.snapshotDetails() != null) {
            sb.append("SnapshotDetails: ").append(this.snapshotDetails()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.statusMessage() != null) {
            sb.append("StatusMessage: ").append(this.statusMessage()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String architecture;
        private String description;
        private String hypervisor;
        private String imageId;
        private String importTaskId;
        private String licenseType;
        private String platform;
        private String progress;
        private List<SnapshotDetail> snapshotDetails;
        private String status;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportImageResponse model) {
            this.setArchitecture(model.architecture);
            this.setDescription(model.description);
            this.setHypervisor(model.hypervisor);
            this.setImageId(model.imageId);
            this.setImportTaskId(model.importTaskId);
            this.setLicenseType(model.licenseType);
            this.setPlatform(model.platform);
            this.setProgress(model.progress);
            this.setSnapshotDetails(model.snapshotDetails);
            this.setStatus(model.status);
            this.setStatusMessage(model.statusMessage);
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getHypervisor() {
            return this.hypervisor;
        }

        @Override
        public final Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        public final void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getImportTaskId() {
            return this.importTaskId;
        }

        @Override
        public final Builder importTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
            return this;
        }

        public final void setImportTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
        }

        public final String getLicenseType() {
            return this.licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getProgress() {
            return this.progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final Collection<SnapshotDetail> getSnapshotDetails() {
            return this.snapshotDetails;
        }

        @Override
        public final Builder snapshotDetails(Collection<SnapshotDetail> snapshotDetails) {
            this.snapshotDetails = SnapshotDetailListCopier.copy(snapshotDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotDetails(SnapshotDetail ... snapshotDetails) {
            this.snapshotDetails(Arrays.asList(snapshotDetails));
            return this;
        }

        public final void setSnapshotDetails(Collection<SnapshotDetail> snapshotDetails) {
            this.snapshotDetails = SnapshotDetailListCopier.copy(snapshotDetails);
        }

        @SafeVarargs
        public final void setSnapshotDetails(SnapshotDetail ... snapshotDetails) {
            this.snapshotDetails(Arrays.asList(snapshotDetails));
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public ImportImageResponse build() {
            return new ImportImageResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImportImageResponse> {
        public Builder architecture(String var1);

        public Builder description(String var1);

        public Builder hypervisor(String var1);

        public Builder imageId(String var1);

        public Builder importTaskId(String var1);

        public Builder licenseType(String var1);

        public Builder platform(String var1);

        public Builder progress(String var1);

        public Builder snapshotDetails(Collection<SnapshotDetail> var1);

        public Builder snapshotDetails(SnapshotDetail ... var1);

        public Builder status(String var1);

        public Builder statusMessage(String var1);
    }
}

