/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.ArchitectureValues;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMappingListCopier;
import software.amazon.awssdk.services.ec2.model.DeviceType;
import software.amazon.awssdk.services.ec2.model.HypervisorType;
import software.amazon.awssdk.services.ec2.model.ImageState;
import software.amazon.awssdk.services.ec2.model.ImageTypeValues;
import software.amazon.awssdk.services.ec2.model.PlatformValues;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.model.ProductCodeListCopier;
import software.amazon.awssdk.services.ec2.model.StateReason;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.VirtualizationType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Image
implements ToCopyableBuilder<Builder, Image> {
    private final String architecture;
    private final String creationDate;
    private final String imageId;
    private final String imageLocation;
    private final String imageType;
    private final String kernelId;
    private final String ownerId;
    private final String platform;
    private final List<ProductCode> productCodes;
    private final String ramdiskId;
    private final String state;
    private final List<BlockDeviceMapping> blockDeviceMappings;
    private final String description;
    private final Boolean enaSupport;
    private final String hypervisor;
    private final String imageOwnerAlias;
    private final String name;
    private final String rootDeviceName;
    private final String rootDeviceType;
    private final String sriovNetSupport;
    private final StateReason stateReason;
    private final List<Tag> tags;
    private final String virtualizationType;
    private final Boolean publicLaunchPermissions;

    private Image(BuilderImpl builder) {
        this.architecture = builder.architecture;
        this.creationDate = builder.creationDate;
        this.imageId = builder.imageId;
        this.imageLocation = builder.imageLocation;
        this.imageType = builder.imageType;
        this.kernelId = builder.kernelId;
        this.ownerId = builder.ownerId;
        this.platform = builder.platform;
        this.productCodes = builder.productCodes;
        this.ramdiskId = builder.ramdiskId;
        this.state = builder.state;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.description = builder.description;
        this.enaSupport = builder.enaSupport;
        this.hypervisor = builder.hypervisor;
        this.imageOwnerAlias = builder.imageOwnerAlias;
        this.name = builder.name;
        this.rootDeviceName = builder.rootDeviceName;
        this.rootDeviceType = builder.rootDeviceType;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.stateReason = builder.stateReason;
        this.tags = builder.tags;
        this.virtualizationType = builder.virtualizationType;
        this.publicLaunchPermissions = builder.publicLaunchPermissions;
    }

    public String architecture() {
        return this.architecture;
    }

    public String creationDate() {
        return this.creationDate;
    }

    public String imageId() {
        return this.imageId;
    }

    public String imageLocation() {
        return this.imageLocation;
    }

    public String imageType() {
        return this.imageType;
    }

    public String kernelId() {
        return this.kernelId;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String platform() {
        return this.platform;
    }

    public List<ProductCode> productCodes() {
        return this.productCodes;
    }

    public String ramdiskId() {
        return this.ramdiskId;
    }

    public String state() {
        return this.state;
    }

    public List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public String description() {
        return this.description;
    }

    public Boolean enaSupport() {
        return this.enaSupport;
    }

    public String hypervisor() {
        return this.hypervisor;
    }

    public String imageOwnerAlias() {
        return this.imageOwnerAlias;
    }

    public String name() {
        return this.name;
    }

    public String rootDeviceName() {
        return this.rootDeviceName;
    }

    public String rootDeviceType() {
        return this.rootDeviceType;
    }

    public String sriovNetSupport() {
        return this.sriovNetSupport;
    }

    public StateReason stateReason() {
        return this.stateReason;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String virtualizationType() {
        return this.virtualizationType;
    }

    public Boolean publicLaunchPermissions() {
        return this.publicLaunchPermissions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.architecture() == null ? 0 : this.architecture().hashCode());
        hashCode = 31 * hashCode + (this.creationDate() == null ? 0 : this.creationDate().hashCode());
        hashCode = 31 * hashCode + (this.imageId() == null ? 0 : this.imageId().hashCode());
        hashCode = 31 * hashCode + (this.imageLocation() == null ? 0 : this.imageLocation().hashCode());
        hashCode = 31 * hashCode + (this.imageType() == null ? 0 : this.imageType().hashCode());
        hashCode = 31 * hashCode + (this.kernelId() == null ? 0 : this.kernelId().hashCode());
        hashCode = 31 * hashCode + (this.ownerId() == null ? 0 : this.ownerId().hashCode());
        hashCode = 31 * hashCode + (this.platform() == null ? 0 : this.platform().hashCode());
        hashCode = 31 * hashCode + (this.productCodes() == null ? 0 : this.productCodes().hashCode());
        hashCode = 31 * hashCode + (this.ramdiskId() == null ? 0 : this.ramdiskId().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.blockDeviceMappings() == null ? 0 : this.blockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.enaSupport() == null ? 0 : this.enaSupport().hashCode());
        hashCode = 31 * hashCode + (this.hypervisor() == null ? 0 : this.hypervisor().hashCode());
        hashCode = 31 * hashCode + (this.imageOwnerAlias() == null ? 0 : this.imageOwnerAlias().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.rootDeviceName() == null ? 0 : this.rootDeviceName().hashCode());
        hashCode = 31 * hashCode + (this.rootDeviceType() == null ? 0 : this.rootDeviceType().hashCode());
        hashCode = 31 * hashCode + (this.sriovNetSupport() == null ? 0 : this.sriovNetSupport().hashCode());
        hashCode = 31 * hashCode + (this.stateReason() == null ? 0 : this.stateReason().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.virtualizationType() == null ? 0 : this.virtualizationType().hashCode());
        hashCode = 31 * hashCode + (this.publicLaunchPermissions() == null ? 0 : this.publicLaunchPermissions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image)obj;
        if (other.architecture() == null ^ this.architecture() == null) {
            return false;
        }
        if (other.architecture() != null && !other.architecture().equals(this.architecture())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.imageId() == null ^ this.imageId() == null) {
            return false;
        }
        if (other.imageId() != null && !other.imageId().equals(this.imageId())) {
            return false;
        }
        if (other.imageLocation() == null ^ this.imageLocation() == null) {
            return false;
        }
        if (other.imageLocation() != null && !other.imageLocation().equals(this.imageLocation())) {
            return false;
        }
        if (other.imageType() == null ^ this.imageType() == null) {
            return false;
        }
        if (other.imageType() != null && !other.imageType().equals(this.imageType())) {
            return false;
        }
        if (other.kernelId() == null ^ this.kernelId() == null) {
            return false;
        }
        if (other.kernelId() != null && !other.kernelId().equals(this.kernelId())) {
            return false;
        }
        if (other.ownerId() == null ^ this.ownerId() == null) {
            return false;
        }
        if (other.ownerId() != null && !other.ownerId().equals(this.ownerId())) {
            return false;
        }
        if (other.platform() == null ^ this.platform() == null) {
            return false;
        }
        if (other.platform() != null && !other.platform().equals(this.platform())) {
            return false;
        }
        if (other.productCodes() == null ^ this.productCodes() == null) {
            return false;
        }
        if (other.productCodes() != null && !other.productCodes().equals(this.productCodes())) {
            return false;
        }
        if (other.ramdiskId() == null ^ this.ramdiskId() == null) {
            return false;
        }
        if (other.ramdiskId() != null && !other.ramdiskId().equals(this.ramdiskId())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.blockDeviceMappings() == null ^ this.blockDeviceMappings() == null) {
            return false;
        }
        if (other.blockDeviceMappings() != null && !other.blockDeviceMappings().equals(this.blockDeviceMappings())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.enaSupport() == null ^ this.enaSupport() == null) {
            return false;
        }
        if (other.enaSupport() != null && !other.enaSupport().equals(this.enaSupport())) {
            return false;
        }
        if (other.hypervisor() == null ^ this.hypervisor() == null) {
            return false;
        }
        if (other.hypervisor() != null && !other.hypervisor().equals(this.hypervisor())) {
            return false;
        }
        if (other.imageOwnerAlias() == null ^ this.imageOwnerAlias() == null) {
            return false;
        }
        if (other.imageOwnerAlias() != null && !other.imageOwnerAlias().equals(this.imageOwnerAlias())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.rootDeviceName() == null ^ this.rootDeviceName() == null) {
            return false;
        }
        if (other.rootDeviceName() != null && !other.rootDeviceName().equals(this.rootDeviceName())) {
            return false;
        }
        if (other.rootDeviceType() == null ^ this.rootDeviceType() == null) {
            return false;
        }
        if (other.rootDeviceType() != null && !other.rootDeviceType().equals(this.rootDeviceType())) {
            return false;
        }
        if (other.sriovNetSupport() == null ^ this.sriovNetSupport() == null) {
            return false;
        }
        if (other.sriovNetSupport() != null && !other.sriovNetSupport().equals(this.sriovNetSupport())) {
            return false;
        }
        if (other.stateReason() == null ^ this.stateReason() == null) {
            return false;
        }
        if (other.stateReason() != null && !other.stateReason().equals(this.stateReason())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.virtualizationType() == null ^ this.virtualizationType() == null) {
            return false;
        }
        if (other.virtualizationType() != null && !other.virtualizationType().equals(this.virtualizationType())) {
            return false;
        }
        if (other.publicLaunchPermissions() == null ^ this.publicLaunchPermissions() == null) {
            return false;
        }
        return other.publicLaunchPermissions() == null || other.publicLaunchPermissions().equals(this.publicLaunchPermissions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.architecture() != null) {
            sb.append("Architecture: ").append(this.architecture()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (this.imageId() != null) {
            sb.append("ImageId: ").append(this.imageId()).append(",");
        }
        if (this.imageLocation() != null) {
            sb.append("ImageLocation: ").append(this.imageLocation()).append(",");
        }
        if (this.imageType() != null) {
            sb.append("ImageType: ").append(this.imageType()).append(",");
        }
        if (this.kernelId() != null) {
            sb.append("KernelId: ").append(this.kernelId()).append(",");
        }
        if (this.ownerId() != null) {
            sb.append("OwnerId: ").append(this.ownerId()).append(",");
        }
        if (this.platform() != null) {
            sb.append("Platform: ").append(this.platform()).append(",");
        }
        if (this.productCodes() != null) {
            sb.append("ProductCodes: ").append(this.productCodes()).append(",");
        }
        if (this.ramdiskId() != null) {
            sb.append("RamdiskId: ").append(this.ramdiskId()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.blockDeviceMappings()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.enaSupport() != null) {
            sb.append("EnaSupport: ").append(this.enaSupport()).append(",");
        }
        if (this.hypervisor() != null) {
            sb.append("Hypervisor: ").append(this.hypervisor()).append(",");
        }
        if (this.imageOwnerAlias() != null) {
            sb.append("ImageOwnerAlias: ").append(this.imageOwnerAlias()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.rootDeviceName() != null) {
            sb.append("RootDeviceName: ").append(this.rootDeviceName()).append(",");
        }
        if (this.rootDeviceType() != null) {
            sb.append("RootDeviceType: ").append(this.rootDeviceType()).append(",");
        }
        if (this.sriovNetSupport() != null) {
            sb.append("SriovNetSupport: ").append(this.sriovNetSupport()).append(",");
        }
        if (this.stateReason() != null) {
            sb.append("StateReason: ").append(this.stateReason()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.virtualizationType() != null) {
            sb.append("VirtualizationType: ").append(this.virtualizationType()).append(",");
        }
        if (this.publicLaunchPermissions() != null) {
            sb.append("PublicLaunchPermissions: ").append(this.publicLaunchPermissions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String architecture;
        private String creationDate;
        private String imageId;
        private String imageLocation;
        private String imageType;
        private String kernelId;
        private String ownerId;
        private String platform;
        private List<ProductCode> productCodes;
        private String ramdiskId;
        private String state;
        private List<BlockDeviceMapping> blockDeviceMappings;
        private String description;
        private Boolean enaSupport;
        private String hypervisor;
        private String imageOwnerAlias;
        private String name;
        private String rootDeviceName;
        private String rootDeviceType;
        private String sriovNetSupport;
        private StateReason stateReason;
        private List<Tag> tags;
        private String virtualizationType;
        private Boolean publicLaunchPermissions;

        private BuilderImpl() {
        }

        private BuilderImpl(Image model) {
            this.setArchitecture(model.architecture);
            this.setCreationDate(model.creationDate);
            this.setImageId(model.imageId);
            this.setImageLocation(model.imageLocation);
            this.setImageType(model.imageType);
            this.setKernelId(model.kernelId);
            this.setOwnerId(model.ownerId);
            this.setPlatform(model.platform);
            this.setProductCodes(model.productCodes);
            this.setRamdiskId(model.ramdiskId);
            this.setState(model.state);
            this.setBlockDeviceMappings(model.blockDeviceMappings);
            this.setDescription(model.description);
            this.setEnaSupport(model.enaSupport);
            this.setHypervisor(model.hypervisor);
            this.setImageOwnerAlias(model.imageOwnerAlias);
            this.setName(model.name);
            this.setRootDeviceName(model.rootDeviceName);
            this.setRootDeviceType(model.rootDeviceType);
            this.setSriovNetSupport(model.sriovNetSupport);
            this.setStateReason(model.stateReason);
            this.setTags(model.tags);
            this.setVirtualizationType(model.virtualizationType);
            this.setPublicLaunchPermissions(model.publicLaunchPermissions);
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(ArchitectureValues architecture) {
            this.architecture(architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final void setArchitecture(ArchitectureValues architecture) {
            this.architecture(architecture.toString());
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getImageLocation() {
            return this.imageLocation;
        }

        @Override
        public final Builder imageLocation(String imageLocation) {
            this.imageLocation = imageLocation;
            return this;
        }

        public final void setImageLocation(String imageLocation) {
            this.imageLocation = imageLocation;
        }

        public final String getImageType() {
            return this.imageType;
        }

        @Override
        public final Builder imageType(String imageType) {
            this.imageType = imageType;
            return this;
        }

        @Override
        public final Builder imageType(ImageTypeValues imageType) {
            this.imageType(imageType.toString());
            return this;
        }

        public final void setImageType(String imageType) {
            this.imageType = imageType;
        }

        public final void setImageType(ImageTypeValues imageType) {
            this.imageType(imageType.toString());
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformValues platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final void setPlatform(PlatformValues platform) {
            this.platform(platform.toString());
        }

        public final Collection<ProductCode> getProductCodes() {
            return this.productCodes;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
        }

        @SafeVarargs
        public final void setProductCodes(ProductCode ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ImageState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(ImageState state) {
            this.state(state.toString());
        }

        public final Collection<BlockDeviceMapping> getBlockDeviceMappings() {
            return this.blockDeviceMappings;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
        }

        @SafeVarargs
        public final void setBlockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getEnaSupport() {
            return this.enaSupport;
        }

        @Override
        public final Builder enaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final void setEnaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
        }

        public final String getHypervisor() {
            return this.hypervisor;
        }

        @Override
        public final Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        @Override
        public final Builder hypervisor(HypervisorType hypervisor) {
            this.hypervisor(hypervisor.toString());
            return this;
        }

        public final void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        public final void setHypervisor(HypervisorType hypervisor) {
            this.hypervisor(hypervisor.toString());
        }

        public final String getImageOwnerAlias() {
            return this.imageOwnerAlias;
        }

        @Override
        public final Builder imageOwnerAlias(String imageOwnerAlias) {
            this.imageOwnerAlias = imageOwnerAlias;
            return this;
        }

        public final void setImageOwnerAlias(String imageOwnerAlias) {
            this.imageOwnerAlias = imageOwnerAlias;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRootDeviceName() {
            return this.rootDeviceName;
        }

        @Override
        public final Builder rootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
            return this;
        }

        public final void setRootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
        }

        public final String getRootDeviceType() {
            return this.rootDeviceType;
        }

        @Override
        public final Builder rootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
            return this;
        }

        @Override
        public final Builder rootDeviceType(DeviceType rootDeviceType) {
            this.rootDeviceType(rootDeviceType.toString());
            return this;
        }

        public final void setRootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
        }

        public final void setRootDeviceType(DeviceType rootDeviceType) {
            this.rootDeviceType(rootDeviceType.toString());
        }

        public final String getSriovNetSupport() {
            return this.sriovNetSupport;
        }

        @Override
        public final Builder sriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final void setSriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
        }

        public final StateReason getStateReason() {
            return this.stateReason;
        }

        @Override
        public final Builder stateReason(StateReason stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final void setStateReason(StateReason stateReason) {
            this.stateReason = stateReason;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
        }

        public final String getVirtualizationType() {
            return this.virtualizationType;
        }

        @Override
        public final Builder virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        @Override
        public final Builder virtualizationType(VirtualizationType virtualizationType) {
            this.virtualizationType(virtualizationType.toString());
            return this;
        }

        public final void setVirtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
        }

        public final void setVirtualizationType(VirtualizationType virtualizationType) {
            this.virtualizationType(virtualizationType.toString());
        }

        public final Boolean getPublicLaunchPermissions() {
            return this.publicLaunchPermissions;
        }

        @Override
        public final Builder publicLaunchPermissions(Boolean publicLaunchPermissions) {
            this.publicLaunchPermissions = publicLaunchPermissions;
            return this;
        }

        public final void setPublicLaunchPermissions(Boolean publicLaunchPermissions) {
            this.publicLaunchPermissions = publicLaunchPermissions;
        }

        public Image build() {
            return new Image(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Image> {
        public Builder architecture(String var1);

        public Builder architecture(ArchitectureValues var1);

        public Builder creationDate(String var1);

        public Builder imageId(String var1);

        public Builder imageLocation(String var1);

        public Builder imageType(String var1);

        public Builder imageType(ImageTypeValues var1);

        public Builder kernelId(String var1);

        public Builder ownerId(String var1);

        public Builder platform(String var1);

        public Builder platform(PlatformValues var1);

        public Builder productCodes(Collection<ProductCode> var1);

        public Builder productCodes(ProductCode ... var1);

        public Builder ramdiskId(String var1);

        public Builder state(String var1);

        public Builder state(ImageState var1);

        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder description(String var1);

        public Builder enaSupport(Boolean var1);

        public Builder hypervisor(String var1);

        public Builder hypervisor(HypervisorType var1);

        public Builder imageOwnerAlias(String var1);

        public Builder name(String var1);

        public Builder rootDeviceName(String var1);

        public Builder rootDeviceType(String var1);

        public Builder rootDeviceType(DeviceType var1);

        public Builder sriovNetSupport(String var1);

        public Builder stateReason(StateReason var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder virtualizationType(String var1);

        public Builder virtualizationType(VirtualizationType var1);

        public Builder publicLaunchPermissions(Boolean var1);
    }
}

